//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.fts;
using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>Make a connection from an inlet to an outlet </summary>

    internal class MoveReverseConnect : Interaction
    {
        internal Point moveStart = new Point();
        internal GraphicObject src;
        internal int outlet;
        internal GraphicObject dst;
        internal int inlet;

        internal override void configureInputFilter(InteractionEngine filter)
        {
            filter.isFollowingMoves = true; // need the drag
            filter.isFollowingInOutletLocations = true;
            filter.isFollowingOutletLocations = true;
            filter.isFollowingAlsoConnectionLocations = false;
            filter.isAutoScrolling = true;
            filter.isKeyListening = true;
        }

        // Utility method

        private void doConnection(ErmesSketchPad editor, GraphicObject src, int outlet, GraphicObject dst, int inlet)
        {
            if (src == dst)
            {
                editor.showMessage("Cannot connect an object to itself !");
                return;
            }

            editor.resetUndoRedo();

            editor.addingConnection();
            editor.FtsPatcher.RequestAddConnection(src.FtsObject, outlet, dst.FtsObject, inlet);
        }

        public void setDest(GraphicObject obj, int inlet)
        {
            dst = obj;
            inlet = inlet;
            moveStart.X = dst.getInletAnchorX(inlet);
            moveStart.Y = dst.getInletAnchorY(inlet);
        }

        internal bool destinationChoosen = false;

        internal override void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            if (Squeack.isUp(squeack) && Squeack.onInlet(squeack))
            {
                ErmesSelection.patcherSelection.redraw();
                ErmesSelection.patcherSelection.DeselectAll();

                dst = (GraphicObject)area.Target;
                inlet = area.Number;

                moveStart.X = dst.getInletAnchorX(inlet);
                moveStart.Y = dst.getInletAnchorY(inlet);
                editor.ConnectingObject = dst;
                //editor.resetHighlightedInlet();
            }
            else if (Squeack.isDown(squeack) && Squeack.isShift(squeack))
            {
                //  do the connection if we have a destination

                if (destinationChoosen)
                {
                    editor.resetHighlightedOutlet();
                    doConnection(editor, src, outlet, dst, inlet);
                }
            }
            else if (Squeack.isDown(squeack))
            {
                //  do the connection if we have a destination

                if (destinationChoosen)
                {
                    editor.resetHighlightedOutlet();
                    editor.resetHighlightedInlet();
                    doConnection(editor, src, outlet, dst, inlet);
                }

                // clean up
                editor.DisplayList.NoDrag();
                editor.DisplayList.RedrawDragLine();
                //                editor.Cursor = System.Windows.Forms.Cursors.Default;
                editor.ConnectingObject = null;
                destinationChoosen = false;

                editor.endInteraction();
            }
            else if (Squeack.isMove(squeack) && Squeack.onOutlet(squeack))
            {
                if ((!destinationChoosen) || src != (GraphicObject)area.Target || outlet != area.Number)
                {

                    if (!editor.DisplayList.ThisConnectionExist((GraphicObject)area.Target, area.Number, dst, inlet))
                    {
                        src = (GraphicObject)area.Target;
                        outlet = area.Number;
                        editor.setHighlightedOutlet(src, outlet);
                        destinationChoosen = true;
                        editor.DisplayList.DragLine();
                        editor.DisplayList.RedrawDragLine();
                        editor.DisplayList.SetDragLine(moveStart.X, moveStart.Y, src.getOutletAnchorX(outlet), src.getOutletAnchorY(outlet));
                        editor.DisplayList.RedrawDragLine();
                    }
                    else
                    {
                        destinationChoosen = false;
                        editor.resetHighlightedOutlet();
                        src = null;

                        editor.DisplayList.DragLine();
                        editor.DisplayList.RedrawDragLine();
                        editor.DisplayList.SetDragLine(moveStart.X, moveStart.Y, mouse.X, mouse.Y);
                        editor.DisplayList.RedrawDragLine();
                    }
                }
            }
            else if (Squeack.isMove(squeack))
            {
                if (destinationChoosen)
                {
                    editor.resetHighlightedOutlet();
                    destinationChoosen = false;
                }

                editor.DisplayList.DragLine();
                editor.DisplayList.RedrawDragLine();
                editor.DisplayList.SetDragLine(moveStart.X, moveStart.Y, mouse.X, mouse.Y);
                editor.DisplayList.RedrawDragLine();
            }
            else if ((squeack == Squeack.SHIFT_UP) || (squeack == Squeack.ESCAPE) || (squeack == Squeack.DELETE))
            {
                editor.resetHighlightedInlet();
                editor.DisplayList.RedrawDragLine();
                editor.DisplayList.NoDrag();
                editor.ConnectingObject = null;
                destinationChoosen = false;

                editor.endInteraction();
            }
        }
    }
}