//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.fts;
using ircam.jmax.dialogs;
using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>The interaction handling help patches; 
    /// started, and completed, by a AltClick on an object.
    /// </summary>

    internal class PopUpInteraction : Interaction
    {
        internal bool locked = false;

        internal override void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            GraphicObject obj = null;

            //deselect
            if (ErmesSelection.patcherSelection.hasObjects)
            {
                ErmesSelection.patcherSelection.DeselectAll();
                //HACK: 'javax.swing.JComponent.repaint()' was not converted.
                //editor.repaint();
            }

            if ((!locked) && Squeack.isPopUp(squeack))
            {
                locked = true;
                obj = (GraphicObject)area.Target;
                if (!obj.isPopUpVisible)
                {
                    obj.popUpUpdate(Squeack.onInlet(squeack), Squeack.onOutlet(squeack), area);
                    obj.popUpEdit(mouse);
                }
                locked = false;
                editor.endInteraction();
            }
        }
    }
}