//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>The Master interaction for the run mode.
    /// Mostly, each method install a slave interaction,
    /// preallocated in the constructor, and dispatch the event
    /// to it.
    /// </summary>

    internal class RunModeInteraction : Interaction
    {
        // Standard interaction in run mode.
        // To add a new one, just

        internal override void configureInputFilter(InteractionEngine filter)
        {
            filter.isFollowingLocations = true;
        }

        internal override Interaction delegateSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            switch (squeack)
            {
                /*case (Squeack.ALT | Squeack.DOWN | Squeack.TEXT):
                case (Squeack.ALT | Squeack.DOWN | Squeack.OBJECT):*/
                case (Squeack.MIDDLE_BUTTON | Squeack.DOWN | Squeack.TEXT):
                case (Squeack.MIDDLE_BUTTON | Squeack.DOWN | Squeack.OBJECT):
                    return Interactions.helpInteraction;

                case (Squeack.POP_UP | Squeack.OBJECT):
                    return Interactions.runPopUpInteraction;

                case (Squeack.DOWN | Squeack.OBJECT):
                case (Squeack.SHIFT | Squeack.DOWN | Squeack.OBJECT):
                    return Interactions.runCtrlInteraction;

                case (Squeack.DOWN | Squeack.TEXT):
                    return Interactions.runCtrlInteraction;

                case (Squeack.DOUBLE_CLICK | Squeack.OBJECT):
                    return Interactions.doubleClickEdit;

                case (Squeack.DOUBLE_CLICK | Squeack.TEXT):
                    return Interactions.doubleClickEdit;

                default:
                    return null;
            }
        }
    }
}