//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;
using System.Windows.Forms;

using ircam.jmax.fts;
using ircam.fts.client;
using ircam.jmax.toolkit;
using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.interactions;

namespace ircam.jmax.editors.patcher.objects
{
    //
    // The base class of the ermes objects which are user-editable
    // (Message, Standard, Patcher).
    //

    abstract public class Editable : GraphicObject
    {
        //private Font theFont = null;

        internal bool editing = false;
        internal int defaultWidth = -1;

        [NonSerialized()]
        public IObjectRenderer renderer;

        public Editable(FtsGraphicObject theFtsObject) : base(theFtsObject)
        {
            AFont = new Font("SansSerif", 8);

            computeRenderer();
            //renderer.update();
        }

        public override void setDefaults()
        {
            setWidth(DefaultWidth);
        }

        public void updateDimensions()
        {
            //renderer.update();
            //base.Height = (renderer.Height + TextHeightOffset);
            //base.Width = (renderer.Width + TextWidthOffset);
        }

        public void UpdateDimensionsNoConnections()
        {
            //UNDONE:
            //renderer.update();
            //base.HeightNoConnections = renderer.Height + TextHeightOffset;
        }

        protected internal void computeRenderer()
        {
            //UNDONE: Interface 'javax.swing.Renderer' was not converted.
            //            Renderer r;
            //            renderer = new TextRenderer(this);
        }

        /* it's still there only to redefine Patcher object */
        /* when will be asynchronous remove them and use "redefined" */
        public override void redefine(string text)
        {
            computeRenderer();

            updateDimensions();

            if (itsSketchPad.isAutomaticFitToText)
            {
                Redraw();
                fitToText();
            }
            else
                Redraw();

            base.redefine(text);
        }

        public int MinimumWidth
        {
            get
            {
                //UNDONE: Interface 'javax.swing.Renderer' was not converted.
                //      if (renderer is TextRenderer)
                //          return ((TextRenderer) renderer).ColWidth + TextWidthOffset;
                //      else
                //          return renderer.Width;
                return defaultWidth;
            }
        }

        public int DefaultWidth
        {
            get
            {
                if (defaultWidth == -1)
                {
                    //UPGRADE_ISSUE: Method 'java.awt.FontMetrics.stringWidth' was not converted.
                    //                    defaultWidth = FontMetrics.stringWidth("pack 1 2 3") + 2 * TextXOffset;
                }

                return defaultWidth;
            }
            set
            {
                defaultWidth = value;
            }
        }

        // redefined from base class
        public void setWidth(int w)
        {
            //if (w <= 0)
            //    base.Width = (MinimumWidth + VariableWidth);
            //else if (renderer.canResizeWidthTo(w - VariableWidth - TextWidthOffset))
            //    base.Width = w;
            //else
            //    base.Width = (MinimumWidth + VariableWidth);

            //int height = renderer.Height + TextHeightOffset;
            //if (Height != height)
            //    base.Height = height;
        }

        public void forceWidth(int w)
        {
            base.Width = w;
        }

        // redefined from base class, only when not editing
        // This way, changing the height from outside is forbidden
        public void setHeight(int v)
        {
            if (editing)
                base.Height = v;
        }

        public void forceHeight(int v)
        {
            base.Height = v;
        }

        // redefined from base class        
        public virtual void setFont(System.Drawing.Font f)
        {
            //base.itsFont = f;
            //renderer.update();
            //base.Height = (renderer.Height + TextHeightOffset);
            //Redraw();
        }

        public void forceFont(System.Drawing.Font f)
        {
            //base.Font = f;
            //renderer.update();
        }

        public override void setCurrentFont(System.Drawing.Font font)
        {
            //base.setCurrentFont(font);
            //renderer.update();
        }

        public override void fitToText()
        {
            //renderer.update();
            //UNDONE: 
            //      int w = ((TextRenderer) renderer).TextWidth + VariableWidth + TextWidthOffset + 2;
            //            
            //      if (w < MinimumWidth)
            //          base.Width = (MinimumWidth + VariableWidth);
            //      else
            //          base.Width = w;
            //
            //      if (!((TextRenderer) renderer).isMultiLine)
            //          base.setHeight(((TextRenderer) renderer).RHeight + TextHeightOffset);
            //      else
            //          base.setHeight(((TextRenderer) renderer).TextHeight + TextHeightOffset);

            Redraw();
        }

        public string WidthToText
        {
            set
            {
                //UNDONE: Method 'javax.swing.SwingUtilities.computeStringWidth' was not converted.
                //      int tLength = SwingUtilities.computeStringWidth(FontMetrics, value) + TextWidthOffset + 2;
                int tLength = 0;
                if (tLength < DefaultWidth)
                    tLength = DefaultWidth;

                base.Width = tLength;
            }
        }

        // ----------------------------------------
        // ``Args'' property
        // ----------------------------------------
        abstract public string Args { get; }

        // ----------------------------------------
        // ``TextBackground'' property
        // ----------------------------------------
        abstract public System.Drawing.Color TextBackground { get; }
        abstract public System.Drawing.Color TextForeground { get; }

        // Properties to position correctly the text editor
        abstract public int TextXOffset { get; }
        abstract public int TextYOffset { get; }
        abstract public int TextWidthOffset { get; }
        abstract public int TextHeightOffset { get; }

        abstract public bool isMultiline { get; }

        public bool Editing
        {
            get
            {
                return editing;
            }
            set
            {
                editing = value;
            }
        }

        // ----------------------------------------
        // Property handling
        // ----------------------------------------
        public void InletsChanged(int n)
        {
            updateInOutlets();
            Redraw();
            redrawConnections();
            itsSketchPad.DisplayList.UpdateConnectionsFor(this);
        }

        public void OutletsChanged(int n)
        {
            updateInOutlets();
            Redraw();
            redrawConnections();
            itsSketchPad.DisplayList.UpdateConnectionsFor(this);
        }

        public void DrawContent(Graphics g)
        {
            if (editing)
                return;

            g.FillRectangle(new SolidBrush(TextBackground), X + TextXOffset, Y + TextYOffset, Width - TextWidthOffset, Height - TextHeightOffset);
            g.DrawString(Args, AFont, new SolidBrush(TextForeground), X + TextXOffset, Y + TextYOffset);
        }

        // Text Sensibility area 
        protected internal override SensibilityArea findSensibilityArea(int mouseX, int mouseY)
        {
            int dx = mouseX - (X + TextXOffset);
            int dy = mouseY - (Y + TextYOffset);

            if ((dx >= 0) && (dx < Width - VariableWidth - TextWidthOffset) && (dy >= 0) && (dy < Height - TextHeightOffset))
            {
                return SensibilityArea.getSensibilityArea(this, Squeack.TEXT);
            }
            else
                return base.findSensibilityArea(mouseX, mouseY);
        }

        // Edit
        public override void Edit(System.Drawing.Point point)
        {
            itsSketchPad.textEditObject(this, point);
        }

        public override void popUpUpdate(bool onInlet, bool onOutlet, SensibilityArea area)
        {
            base.popUpUpdate(onInlet, onOutlet, area);
            //  ObjectPopUp.Instance.Add(mySeparator);
            //  TextPopUpMenu.update(this);
            //  ObjectPopUp.addMenu(TextPopUpMenu.Instance);
        }
        public override void popUpReset()
        {
            base.popUpReset();
            //  ObjectPopUp.removeMenu(TextPopUpMenu.Instance);
            //  ObjectPopUp.Instance.Remove(mySeparator);
        }

        /************** Undo/Redo *******************/
        public override void undo()
        {
            base.undo();
            forceHeight(uh);
        }
        public override void redo()
        {
            base.redo();
            forceHeight(rh);
        }
    }
}