//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.fts.client;
using ircam.jmax;

namespace ircam.jmax.fts
{
    public class FtsAudioLabel : FtsObject
    {
        protected internal FtsArgs args = new FtsArgs();

        static FtsAudioLabel()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsAudioLabel), FtsSymbol.Get("label"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsAudioLabel)obj).Label = args.GetSymbol(0).ToString();
                });
            FtsObject.RegisterMessageHandler(typeof(FtsAudioLabel), FtsSymbol.Get("input"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsAudioLabel)obj).Input = args.GetSymbol(0).ToString();
                });
            FtsObject.RegisterMessageHandler(typeof(FtsAudioLabel), FtsSymbol.Get("output"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsAudioLabel)obj).Output = args.GetSymbol(0).ToString();
                });
            FtsObject.RegisterMessageHandler(typeof(FtsAudioLabel), FtsSymbol.Get("input_channel"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsAudioLabel)obj).InputChannel = args.GetInt(0);
                });
            FtsObject.RegisterMessageHandler(typeof(FtsAudioLabel), FtsSymbol.Get("output_channel"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsAudioLabel)obj).OutputChannel = args.GetInt(0);
                });
        }

        public FtsAudioLabel(FtsServer server, FtsObject parent, int id, FtsAtom[] args, int offset, int length)
            : base(server, parent, id)
        {
            label = args[offset].symbolValue.ToString();

            if (length - offset >= 3)
            {
                input = args[offset + 1].symbolValue.ToString();
                inChannel = args[offset + 2].intValue;
            }
            if (length - offset == 5)
            {
                output = args[offset + 3].symbolValue.ToString();
                outChannel = args[offset + 4].intValue;
            }
        }

        public ircam.jmax.editors.configuration.AudioConfigPanel Listener
        {
            set
            {
                this.listener = value;
            }
        }

        /*****************************************************/
        /***********     Client -----> Server    *************/
        /*****************************************************/
        public void RequestChangeLabel(string label)
        {
            args.Clear();
            args.AddSymbol(FtsSymbol.Get(label));

            try
            {
                Send(FtsSymbol.Get("label"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsAudioLabel: I/O Error sending ChangeLabel Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void RequestSetInput(string input)
        {
            args.Clear();
            args.AddSymbol(FtsSymbol.Get(input));

            try
            {
                Send(FtsSymbol.Get("input"), args);
            }
            catch (IOException e)
            {
                System.Console.Error.WriteLine("FtsAudioLabel: I/O Error sending input Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void RequestSetOutput(string output)
        {
            args.Clear();
            args.AddSymbol(FtsSymbol.Get(output));

            try
            {
                Send(FtsSymbol.Get("output"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsAudioLabel: I/O Error sending output Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void RequestSetInChannel(int ch)
        {
            args.Clear();
            args.AddInt(ch);

            try
            {
                Send(FtsSymbol.Get("input_channel"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsAudioLabel: I/O Error sending in_channel Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void RequestSetOutChannel(int ch)
        {
            args.Clear();
            args.AddInt(ch);

            try
            {
                Send(FtsSymbol.Get("output_channel"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsAudioLabel: I/O Error sending out_channel Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        /************************************************************/

        public string Label
        {
            get
            {
                return label;
            }
            set
            {
                this.label = value;
                if (listener != null)
                    listener.LabelNameChanged(this);
            }
        }

        public string Input
        {
            get
            {
                return input;
            }
            set
            {
                input = value;
                if (listener != null)
                    listener.LabelInputChanged(this);
            }
        }

        public int InputChannel
        {
            get
            {
                return inChannel;
            }
            set
            {
                inChannel = value;
                if (listener != null)
                    listener.LabelInChannelChanged(this);
            }
        }

        public string Output
        {
            get
            {
                return output;
            }
            set
            {
                this.output = value;
                if (listener != null)
                    listener.LabelOutputChanged(this);
            }
        }

        public int OutputChannel
        {
            get
            {
                return outChannel;
            }
            set
            {
                outChannel = value;
                if (listener != null)
                    listener.LabelOutChannelChanged(this);
            }
        }

        private string label = null;
        private string input = null;
        private string output = null;
        private int inChannel, outChannel;
        private ircam.jmax.editors.configuration.AudioConfigPanel listener = null;
    }
}