//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

using System;
using System.IO;
using System.Text;
using System.Threading;
using System.Collections;

using ircam.jmax;

namespace ircam.jmax.fts
{
    /// <summary> This class is used to show the FTS standard error by listening on
    /// the FTS process error stream.<BR>
    /// When instantiated with the startFtsErrorStream static method,
    /// it listen an input stream, and writes the result in a file name .fts-stderr
    /// located in user's home directory
    /// </summary>

    public class FtsErrorStreamer
    {
        private StreamReader streamReader;
        private StreamWriter streamWriter;
        private bool running;
        private bool first = true;
        private string fileName;

        private static FtsErrorStreamer errorStreamer;

        public static void StartFtsErrorStreamer(StreamReader streamReader)
        {
            errorStreamer = new FtsErrorStreamer(streamReader);
        }

        public static void StopFtsErrorStreamer()
        {
            errorStreamer.running = false;
        }

        internal FtsErrorStreamer(StreamReader streamReader)
        {
            this.streamReader = streamReader;
            running = true;

            IDictionary en = Environment.GetEnvironmentVariables();
            fileName = (string)en["USERPROFILE"] + "\\" + ".fts-stderr";

            using (FileStream fs = new FileStream(fileName, FileMode.Create, FileAccess.Write, FileShare.None))
            {
                using (streamWriter = new StreamWriter(fs))
                {
                    try
                    {
                        streamWriter.WriteLine("*** Fts Standard Error ***");
                        streamWriter.WriteLine("");
                    }
                    catch (IOException e)
                    {
                        Console.Error.WriteLine("I/O error writing FTS error file '{0}':\n{1}", fileName, e.ToString());
                    }
                }
            }

            Thread t = new Thread(
                delegate()
                {
                    while (running)
                    {
                        int c = streamReader.Read();

                        if ((c == -1) && (!running))
                            return;

                        try
                        {
                            if (c == -1)
                            {
                                running = false;
                                Console.Error.WriteLine("server connection lost\n");
                                JMaxLibrary.FtsQuitted();
                            }
                            else
                            {
                                if (first)
                                {
                                    Console.Error.WriteLine("error log written to " + fileName);

                                    first = false;
                                }
                                streamWriter.Write((char)c);
                            }
                        }
                        catch (IOException e)
                        {
                            Console.Error.WriteLine("Exception in FTS I/O, giving up  !!!\n{0}", e.ToString());

                            running = false;
                        }
                    }
                });
            t.Start();
        }
    }
}