//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;
using System.Collections;

using ircam.jmax;
using ircam.fts.client;

namespace ircam.jmax.fts
{
    /// <summary> This class provide a registration service for help Patches.
    /// The class is filled thru the TCL Command <b>helpPatch</b>.
    /// Note that there is a single help patch data base for all the servers.
    /// 
    /// </summary>
    /// <seealso cref="FtsHelpPatchCmd">
    /// </seealso>
    public class FtsHelpPatchTable
    {
        internal static Hashtable helpTable = new Hashtable(256, 0.99f);
        internal static Hashtable helpSummaryTable = new Hashtable();
        internal static ArrayList helpSummaryVector = new ArrayList();

        /// <summary>Add an help patch for an fts object class </summary>
        static public void Add(string className, string patch)
        {
            helpTable.Add(className, patch);
        }

        /// <summary>Add an help summary patch </summary>
        static public void AddSummary(string name, string patch)
        {
            helpSummaryTable.Add(name, patch);
            helpSummaryVector.Add(name);
        }

        /// <summary>Check if the help patch for a given fts object class exists </summary>
        static public bool Exists(string className)
        {
            return helpTable.ContainsKey(className);
        }

        /// <summary>Check if a named help patch summary exists </summary>
        static public bool SummaryExists(string name)
        {
            return helpSummaryTable.ContainsKey(name);
        }

        /// <summary>Get the help patch filename for a given fts object class exists </summary>
        internal static string GetHelpPatch(string className)
        {
            return (string)helpTable[className];
        }


        /// <summary>Get a named help patch summary filename </summary>
        static public string GetHelpSummaryPatch(string className)
        {
            return (string)helpSummaryTable[className];
        }

        /// <summary>Open an help patch for a given fts object </summary>
        static public bool OpenHelpPatch(FtsObject obj)
        {
            /*if (Exists(obj.ToString()))
            {
                try
                {
                    File file = new File(GetHelpPatch(obj.ToString()));
                    MaxDocument document;

                    document = Mda.loadDocument(obj.GetFts(), file);
                    document.edit();
                }
                catch (MaxDocumentException e)
                {
                    return false;
                }

                return true;
            }
            else*/
            return false;
        }

        /// <summary>Open an help summary patch </summary>

        static public void OpenHelpSummary(string name)
        {
            if (SummaryExists(name))
            {
                string file = GetHelpSummaryPatch(name);
                try
                {
                    JMaxLibrary.Load(file);
                }
                catch (IOException e)
                {
                    Console.Error.WriteLine("[FtsHelpPatchTable]: I/O error opening Help Summary file " + file + " " + e.ToString());
                }
            }
        }

        /// <summary>Get an enumeration of the available summaries </summary>
        static public IEnumerator Summaries
        {
            get
            {
                return helpSummaryVector.GetEnumerator();
            }
        }

        static public int NumSummaries
        {
            get
            {
                return helpSummaryVector.Count;
            }
        }

        static public void Clear()
        {
            helpTable.Clear();
            helpSummaryTable.Clear();
            helpSummaryVector.Clear();
        }
    }
}