//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.fts.client;
using ircam.jmax;
////using ircam.jmax.editors.patcher.objects.NumberBox;

namespace ircam.jmax.fts
{
    /// <summary> A generic FTS object with an int value.
    /// Used for intbox and sliders, for example.
    /// If the listener of this object is an instance
    /// of IFtsIntValueListener, fire it when the we got a new value
    /// from the server.
    /// </summary>
    public class FtsIntValueObject : FtsGraphicObject
    {
        static FtsIntValueObject()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsIntValueObject), FtsSymbol.Get("value"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsIntValueObject)obj).CurrentValue = args.GetInt(0);
                });
        }

        /*****************************************************************************/
        /*                                                                           */
        /*                               CONSTRUCTORS                                */
        /*                                                                           */
        /*****************************************************************************/

        private int intValue;

        [NonSerialized()]
        new protected internal FtsArgs args = new FtsArgs();

        public FtsIntValueObject(FtsServer server, FtsObject parent, int id, string className, FtsAtom[] args, int offset, int length)
            : base(server, parent, id, className, args, offset, length)
        {
            NumberOfInlets = 1;
            NumberOfOutlets = 1;
        }

        public FtsIntValueObject(FtsServer server, FtsObject parent, int id, string className, string arguments)
            : base(server, parent, id, className, arguments)
        {
            NumberOfInlets = 1;
            NumberOfOutlets = 1;
        }

        /// <summary>Get the current value </summary>
        public int Value
        {
            get
            {
                return intValue;
            }
            set
            {
                this.intValue = value;
                args.Clear();
                args.AddInt(value);
                try
                {
                    Send(FtsSymbol.Get("value"), args);
                }
                catch (IOException e)
                {
                    Console.Error.WriteLine("FtsIntValueObject: I/O Error sending setValue Message!");
                    Console.Error.WriteLine(e.StackTrace);
                }
            }
        }

        /// <summary>Ask the server for the latest value </summary>

        public void UpdateValue()
        {
            try
            {
                Send(FtsSymbol.Get("getValue"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsIntValueObject: I/O Error sending getValue Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void SendBang()
        {
            try
            {
                Send(FtsSymbol.Get("click"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsIntValueObject: I/O Error sending bang Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        /* Over write the localPut message to handle value changes;
        */

        internal int CurrentValue
        {
            set
            {
                intValue = value;

                if (ObjectListener is IFtsIntValueListener)
                    ((IFtsIntValueListener)ObjectListener).ValueChanged(value);
            }
        }
    }
}