//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;

using ircam.jmax.editors.patcher;
using ircam.fts.client;
using ircam.jmax;

namespace ircam.jmax.fts
{
    /// <summary>Object set class.
    /// 
    /// </summary>
    public class FtsRuntimeErrors : FtsObject
    {
        private ArrayList list, dataListeners;

        static FtsRuntimeErrors()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsRuntimeErrors), FtsSymbol.Get("postError"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsRuntimeErrors)obj).PostError((FtsGraphicObject)args.GetObject(0), args.GetSymbol(1).ToString());
                });
        }

        private class FtsRuntimeErrorsListener : IFtsEditListener
        {
            public FtsRuntimeErrorsListener(FtsRuntimeErrors ftsRuntimeErrors)
            {
                this.ftsRuntimeErrors = ftsRuntimeErrors;
            }
            public void ObjectAdded(FtsObject obj) { }
            public void ObjectRemoved(FtsObject obj)
            {
                ftsRuntimeErrors.RemoveErrorsOf(obj);
                ftsRuntimeErrors.FireListChanged();
            }
            public void ConnectionAdded(FtsConnection connection) { }
            public void ConnectionRemoved(FtsConnection connection) { }
            public void AtomicAction(bool active) { }

            private FtsRuntimeErrors ftsRuntimeErrors;
        }

        public FtsRuntimeErrors()
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__runtimeerrors"))
        {
            list = new ArrayList();
            dataListeners = new ArrayList();

            FtsPatcherObject.AddGlobalEditListener(new FtsRuntimeErrorsListener(this));
        }

        public void PostError(FtsGraphicObject obj, string description)
        {
            RuntimeError err = new RuntimeError(obj, description);

            RuntimeError oldErr = GetSamePostedError(err);
            if (oldErr != null)
            {
                list.Remove(oldErr);
                err.Counter = oldErr.Counter;
            }

            err.IncrementCounter();
            list.Add(err);
            FireListChanged();
        }

        public void RemoveErrors(int[] ids)
        {
            if (ids.Length > 0)
            {
                for (int i = ids.Length - 1; i >= 0; i--)
                    list.RemoveAt(ids[i]);

                FireListChanged();
            }
        }

        public bool ErrorPosted(RuntimeError err)
        {
            for (IEnumerator e = list.GetEnumerator(); e.MoveNext(); )
            {
                if (((RuntimeError)e.Current).Equals(err))
                    return true;
            }
            return false;
        }

        public void RemoveErrorsOf(FtsObject obj)
        {
            RuntimeError err;
            for (int i = list.Count - 1; i >= 0; i--)
            {
                err = (RuntimeError)list[i];
                if (err.Object == obj)
                    list.RemoveAt(i);
            }
        }

        public RuntimeError GetSamePostedError(RuntimeError err)
        {
            RuntimeError runerr;

            for (IEnumerator e = list.GetEnumerator(); e.MoveNext(); )
            {
                runerr = (RuntimeError)e.Current;
                if (runerr.Equals(err))
                    return runerr;
            }
            return null;
        }

        /// <summary>listmodel interface </summary>
        public object this[int index]
        {
            get
            {
                return list[index];
            }
        }

        public int Size
        {
            get
            {
                return list.Count;
            }
        }

        public void AddListDataListener(IListDataListener l)
        {
            dataListeners.Add(l);
        }

        public void RemoveListDataListener(IListDataListener l)
        {
            dataListeners.Remove(l);
        }

        private void FireListChanged()
        {
            for (IEnumerator e = dataListeners.GetEnumerator(); e.MoveNext(); )
            {
                ((IListDataListener)e.Current).ContentsChanged();
            }
        }
    }
}