//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

using System;

using ircam.fts.client;
using ircam.jmax.toolkit;

namespace ircam.jmax.fts
{
    /// <summary> An fts remote data that offers a built-in undo support.
    /// 
    /// </summary>
    public class FtsUndoableObject : FtsGraphicObject, IUndoableData
    {
        public FtsUndoableObject(FtsServer server, FtsObject parent, int id, string className, FtsAtom[] args, int offset, int length)
            : base(server, parent, id, className, args, offset, length)
        {
            Init();
        }

        public FtsUndoableObject(FtsServer server, FtsObject parent, int id, string className, string description)
            : base(server, parent, id, className, description)
        {
            Init();
        }

        public FtsUndoableObject(FtsServer server, FtsObject parent, int id)
            : base(server, parent, id)
        {
            Init();
        }

        public FtsUndoableObject(FtsServer server, FtsObject parent, FtsSymbol className)
            : base(server, parent, className)
        {
        }

        internal void Init()
        {
            //undoM = new UndoManager();
        }

        /// <summary>NOTE: the begin update - endUpdate methods acts also as a
        /// controller for the actions to undo. If no
        /// beginUpdate has been call, the modification to the
        /// model are not stored in the undo buffers 
        /// </summary>

        public void BeginUpdate()
        {
            inGroup = true;
        }

        public void EndUpdate()
        {
            if (!inGroup)
                return;
            inGroup = false;
        }

        public void PostEdit()
        {
        }

        public bool IsInGroup
        {
            get
            {
                return inGroup;
            }
        }

        public void Undo()
        {
        }

        public void Redo()
        {
        }

        public void ClearAllUndoRedo()
        {
        }

        //----- Fields

        //[NonSerialized()]
        //internal UndoManager undoM;

        [NonSerialized()]
        private bool inGroup = false;
    }
}