//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;
using System.Collections;

using ircam.jmax;

namespace ircam.jmax.toolkit
{
    /// <summary> An handy base class implementing the RenderManager interface. It handles
    /// the layers adding/removing, and the invocation of each Layer in turn on the 
    /// render() calls.
    /// </summary>
    /// <seealso cref="RenderManager">
    /// </seealso>
    public class AbstractRenderer : IRenderManager
    {
        /// <summary> render all the layers in turn </summary>
        public void Render(Graphics g)
        {
            ILayer aLayer;

            for (int i = 0; i < itsLayers.Size; i++)
            {
                aLayer = (ILayer)itsLayers[i];
                aLayer.Render(g, i);
            }
        }

        /// <summary> render the objects in the given rectangle </summary>
        public void Render(Graphics g, Rectangle r)
        {
            ILayer aLayer;

            for (int i = 0; i < itsLayers.Size; i++)
            {
                aLayer = (ILayer)itsLayers[i];
                aLayer.Render(g, r, i);
            }
        }

        /// <summary>add a layer </summary>
        public void AddLayer(ILayer l)
        {
            itsLayers.AddElement(l);
        }

        /// <summary>remove a layer </summary>
        public void RemoveLayer(ILayer l)
        {
            itsLayers.RemoveElement(l);
        }

        /// <summary> returns its (current) event renderer</summary>
        public IObjectRenderer IObjectRenderer
        {
            get
            {
                return null;
            }
        }

        /// <summary> returns the events whose graphic representation contains
        /// the given point.
        /// </summary>
        public IEnumerator ObjectsContaining(int x, int y)
        {
            return null;
        }

        /// <summary> returns the first event containg the given point </summary>
        public object FirstObjectContaining(int x, int y)
        {
            return null;
        }

        /// <summary> returns an enumeration of all the events whose graphic representation
        /// intersects the given rectangle.
        /// </summary>
        public IEnumerator ObjectsIntersecting(int x, int y, int w, int h)
        {
            return null;
        }


        //--- Fields
        protected internal MaxVector itsLayers = new MaxVector();
    }
}