//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

namespace ircam.jmax.toolkit
{
    /// <summary> An utility class implementing the UndoableData interface.</summary>
    /// <seealso cref="UndoableData">
    /// </seealso>
    public abstract class AbstractUndoableObject : IUndoableData
    {
        /// <summary> Start an undoable section </summary>
        public void BeginUpdate()
        {
            inGroup = true;
        }

        /// <summary> Add the given UndoableEdit to the undo Buffers </summary>
        //UPGRADE_TODO: Interface 'javax.swing.undo.UndoableEdit' was not converted. 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="jlca1095"'
        public void PostEdit()
        {
        }

        /// <summary> Signal that the undoable section ended </summary>
        public void EndUpdate()
        {
            inGroup = false;
        }

        /// <summary> undo the last section </summary>
        public void Undo()
        {
        }

        /// <summary>redo the last (undone) section </summary>
        public void Redo()
        {
        }

        /// <summary> Return true if an undoable section have been opened, and not closed yet</summary>
        public bool IsInGroup
        {
            get
            {
                return inGroup;
            }
        }

        //--- Fields
        internal bool inGroup = false;
    }
}