//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> The context for a generic editing session.
    /// it stores the source of graphic events, the graphic destination for 
    /// the drawing operations, the RendererManager, the Frame.
    /// </summary>
    public class GraphicContext
    {
        public GraphicContext() { }

        /// <summary> gets the source</summary>
        /// <summary> sets the source of events, that is: the components that generates
        /// the awt events.
        /// </summary>
        public Control GraphicSource
        {
            get
            {
                return itsGraphicSource;
            }

            set
            {
                itsGraphicSource = value;
            }
        }

        /// <summary> get the destination</summary>
        /// <summary> set the destination, that is the component that will receive the
        /// graphic (drawing) operations
        /// </summary>
        public Control GraphicDestination
        {
            get
            {
                return itsGraphicDestination;
            }

            set
            {
                itsGraphicDestination = value;
            }
        }

        /// <summary> gets the RenderManager</summary>
        /// <summary> sets the RenderManager to be used in this context</summary>
        public IRenderManager IRenderManager
        {
            get
            {
                return itsRenderManager;
            }

            set
            {
                itsRenderManager = value;
            }
        }

        /// <summary> get the status bar</summary>
        /// <summary> set the status bar (should this become standard?)</summary>
        public StatusBar StatusBar
        {
            get
            {
                return itsStatusBar;
            }

            set
            {
                itsStatusBar = value;
            }
        }

        /// <summary>gets the awt Frame this context refers to </summary>
        public Form ItsForm
        {
            get
            {
                if (itsForm != null)
                    return itsForm;
                else
                    return GetForm(itsGraphicDestination);
            }
            set
            {
                itsForm = value;
            }
        }

        /// <summary> Called when this context become the current one.
        /// Override to do special actions like change Selection ownerships
        /// and so on. 
        /// </summary>
        public void Activate() { }

        /// <summary> Called when the destination for the graphic operation is going to be
        /// closed 
        /// </summary>
        public void Destroy() { }

        /// <summary> utility static function:
        /// returns the Frame containing a component (why this function is not in AWT?)
        /// </summary>
        public static Form GetForm(Control c)
        {
            for (ContainerControl p = (ContainerControl)c.Container; p != null; p = (ContainerControl)p.Container)
            {
                if (p is Form)
                {
                    return (Form)p;
                }
            }
            return null;
        }

        //-------------------------------------

        protected internal Control itsGraphicSource;
        protected internal Control itsGraphicDestination;

        internal StatusBar itsStatusBar;

        protected internal IRenderManager itsRenderManager;
        protected internal Form itsForm;
    }
}