//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

namespace ircam.jmax.toolkit
{
    /// <summary> The interface of the objects that needs to be informed 
    /// when a position have been choosen by the user.
    /// </summary>
    /// <seealso cref="MouseTracker">
    /// </seealso>
    public interface IPositionListener
    {
        /// <summary> A position have been choosen.
        /// This callback communicates also the modifier keys
        /// pressed at the moment of the choice.
        /// </summary>
        void PositionChoosen(int x, int y);
    }
}