//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;

namespace ircam.jmax.toolkit
{
    /// <summary> The interface implemented by the handlers of generic selections of objects.
    /// It makes no assumption on the kind of objects and on the model of data.
    /// </summary>
    public interface ISelectionHandler
    {
        /// <summary>select the given object </summary>
        void Select(object obj);

        /// <summary>select the given enumeration of objects.
        /// When possible, use this method instead of
        /// selecting single objects. 
        /// </summary>
        void Select(IEnumerator e);

        /// <summary>remove the given object from the selection</summary>
        void DeSelect(object obj);


        /// <summary>remove the given enumeration of objects from the selection
        /// When possible, use this method instead of
        /// deselecting single objects.    
        /// </summary>
        void DeSelect(IEnumerator e);

        /// <summary>returns true if the object is currently selected</summary>
        bool IsInSelection(object obj);

        /// <summary>returns an enumeration of all the selected objects</summary>
        IEnumerator Selected
        {
            get;
        }

        /// <summary>returns the number of objects in the selection</summary>
        int Size();


        /// <summary>selects all the objects. This method actually
        /// depend on the concrete model used.
        /// </summary>
        void SelectAll();

        /// <summary>deselects all the objects currently selected</summary>
        void DeselectAll();


        /// <summary>ask to be informed when the selection's content changes</summary>
        void AddSelectionListener(ISelectionListener theListener);


        /// <summary>remove the given listener</summary>
        void RemoveSelectionListener(ISelectionListener theListener);
    }
}