//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> a simple interaction module:</summary>
    public class MouseDragTracker : InteractionModule
    {
        /// <summary> constructor.</summary>
        public MouseDragTracker(IDynamicDragListener theListener) : base()
        {
            itsListener = theListener;
        }

        public override void MousePressed(object sender, MouseEventArgs e)
        {
            previousX = e.X;
            previousY = e.Y;
            itsListener.DragStart(previousX, previousY, e);
            InteractionSemaphore.Lock();
        }

        public override void MouseReleased(object sender, MouseEventArgs e)
        {
            itsListener.DragEnd(e.X, e.Y, e);
            InteractionSemaphore.Unlock();
        }

        public override void MouseDragged(object sender, MouseEventArgs e)
        {
            int deltaY = e.Y - previousY;
            int deltaX = e.X - previousX;

            itsListener.DynamicDrag(deltaX, deltaY, e);
            previousX = e.X;
            previousY = e.Y;
        }

        public override void InteractionBeginAt(int x, int y)
        {
            //useless for this kind of interaction module
        }

        //------------- fields
        internal IDynamicDragListener itsListener;
        internal int previousX, previousY;
    }
}