//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Reflection;
using System.Drawing;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> An editor for numeric (bean) properties. 
    /// It edit one property of one object (at a time), 
    /// in the specified edit flavour (for now, only EDIT_FIELD supported.) 
    /// Note that this version takes care of the undo support of the object
    /// it is editing, if any. The object is given a chance to store
    /// its state before being changed. 
    /// </summary>
    public class NumericPropertyEditor
    {
        public NumericPropertyEditor(object target, string propertyName, int flavour)
        {
            //UNDONE: Not Implementd Yet.
            //try
            //{
            //    this.descriptor = propertyName;
            //}
            //catch (IntrospectionException e)
            //{
            //    System.Console.Error.WriteLine("property " + propertyName + "not found for object " + target + "of the target class " + target.GetType().FullName);
            //    return;
            //    // should rise an exception instead
            //}

            if (flavour == EDIT_FIELD_FLAVOUR)
            {
                //UNDONE: Not Implementd Yet.
                //textField.SetBackground(Color.White);
                //textField.AddActionListener();
            }
            else
            {
                System.Console.Error.WriteLine("unsupported flavour");
                return;
                // this will be an exception
            }
        }


        /// <summary> Re-reads and re-display the property value.
        /// This method is to be used when the target can be modified
        /// by sources other then this editor
        /// </summary>
        public void Update()
        {
            //UNDONE: Not Implementd Yet.
            //textField.setText(getAsText());
        }

        /// <summary> sets the TARGET of the editing, that is, the object instance
        /// this editor is editing (not the value of the property) 
        /// </summary>
        public void SetValue(object obj)
        {
            beanInstance = obj;
            Update();
        }

        public bool IsPaintable
        {
            get
            {
                return true;
            }
        }

        public Control CustomComponent
        {
            get
            {
                return textField;
            }
        }

        public void PaintValue(Graphics gfx, Rectangle box)
        {
            //UNDONE: Not Implementd Yet.
            //textField.setText(getAsText());
        }

        /// <summary> invoke the read method of the target, returning the string
        /// representation of the property 
        /// </summary>
        /// <summary> Parse the string we are editing, and invoke the write
        /// method of the target object 
        /// </summary>
        public string AsText
        {
            get
            {
                if (beanInstance == null)
                    return "";

                string theValue = "<unknown>";

                //UNDONE: Not Implementd Yet.
                //if (descriptor.getPropertyType() == null)
                //    return theValue;

                //MethodInfo readMethod = descriptor.getReadMethod();

                //if (readMethod != null && readMethod.GetParameters().Length == 0)
                //{
                //    try
                //    {
                //        object ret = readMethod.Invoke(beanInstance, (System.Object[])null);
                //        if (ret != null)
                //        {
                //            theValue = ret.ToString();
                //        }
                //        else
                //            theValue = "null";
                //    }
                //    catch (ArgumentException e)
                //    {
                //    }
                //    catch (UnauthorizedAccessException e)
                //    {
                //    }
                //    catch (TargetInvocationException e)
                //    {
                //    }
                //}

                return theValue;
            }

            set
            {
                int temp = 0;

                try
                {
                    temp = Int32.Parse(value);
                }
                catch (Exception e)
                {
                }

                param[0] = temp;

                //UNDONE: Not Implementd Yet.
                //if (descriptor.getWriteMethod() != null)
                //{
                //    try
                //    {
                //        descriptor.getWriteMethod().Invoke(beanInstance, (object[])param);
                //    }
                //    catch (UnauthorizedAccessException iacc)
                //    {
                //        System.Console.Error.WriteLine(iacc);
                //    }
                //    catch (ArgumentException iarg)
                //    {
                //        System.Console.Error.WriteLine(iarg);
                //    }
                //    catch (TargetInvocationException itexc)
                //    {
                //        System.Console.Error.WriteLine(itexc);
                //    }
                //    catch (Exception exce)
                //    {
                //        System.Console.Error.WriteLine(exce);
                //    }
                //}
                //else
                //{
                //    System.Console.Error.WriteLine("warning: property " + descriptor.getDisplayName() + " does not have an accessible write method");
                //}
            }

        }



        //--- Fields 
        protected internal object beanInstance;
        protected internal string descriptor;
        protected Control textField;

        public const int EDIT_FIELD_FLAVOUR = 0;
        private object[] param;
    }
}