//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.jmax;
using ircam.jmax.fts;
using ircam.fts.client;

namespace ircam.jmax.guiobj
{
	public class FtsMessConstObject : FtsIntValueObject
	{
        private string message;

        public FtsMessConstObject(FtsServer fts, FtsObject parent, int id, System.String className, FtsAtom[] args, int offset, int length)
            : base(fts, parent, id, className, args[offset].stringValue.Equals(className) ? "" : args[offset].stringValue)
        {
            NumberOfInlets = 1;
            NumberOfOutlets = 1;

            message = Description;
        }

		public string Message
		{
			get
			{
				return message;
			}			
			set
			{
				this.message = value;
				
				args.Clear();
				args.AddRawString(value);
				
				try
				{
					Send(FtsSymbol.Get("set"), args);
				}
				catch (IOException e)
				{
					Console.Error.WriteLine("FtsMessageObject: I/O Error sending set Message!");
                    Console.Error.WriteLine(e.StackTrace);
				}
			}
			
		}
	
		

	}
}