//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.fts;
using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;
using ircam.jmax.editors.patcher.interactions;

namespace ircam.jmax.guiobj
{
    public class MessConst : Editable
	{
		private const int statusInvalid = - 1;
		private const int statusValid = 0;
		private const int statusFlashing = 1;
		private const int statusError = 2;
		private int status = 0;
        private int minWidth = ObjectGeometry.INOUTLET_PAD + ObjectGeometry.HIGHLIGHTED_INOUTLET_WIDTH;
		private int cornerSize = 0;
		private int cornerSizeMax = 0;
		
		public MessConst(FtsGraphicObject theFtsObject) : base(theFtsObject)
		{
			cornerSizeMax = minWidth;
		}

        public override string Args
        {
            get
            {
                return ftsObject.Description;
            }
        }

        public void errorChanged(bool status)
		{
			Redraw();
		}

        public void valueChanged(int status)
		{
            this.status = status;
			
			updateRedraw();
		}
		
		public override void gotSqueack(int squeack, Point mouse, Point oldMouse)
        {
            ((FtsMessConstObject)ftsObject).SendBang();
			// Send a bang message to the system inlet
            if (Squeack.isDown(squeack))
                ((FtsMessConstObject)ftsObject).SendBang();
		}
		
		public void Redefine(string text)
		{
            ((FtsMessConstObject)ftsObject).Message = text;
			
            //computeRenderer();
            //renderer.update();
			
            //redraw();
			redrawConnections();
		}
		
		public void Redefined()
		{
			//UNDONE: Method 'javax.swing.SwingUtilities.invokeLater' was not converted. 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="jlca1095"'
            //public virtual void Run()
            //{
            //    redraw();
            //    fitToText();
            //}
		}
		
		/* Inspector */
		public void Inspect() { }
		
		// ----------------------------------------
		// Text area offset
		// ----------------------------------------
		
		private const int TEXT_X_OFFSET = 3;
		private const int TEXT_Y_OFFSET = 2;

        public override int TextXOffset
        {
            get
            {
                return TEXT_X_OFFSET;
            }
        }

        public override int TextYOffset
        {
            get
            {
                return TEXT_Y_OFFSET;
            }
        }

        public override int TextWidthOffset
        {
            get
            {
                return 5;
            }
        }

        public override int TextHeightOffset
        {
            get
            {
                return 5;
            }
        }

        public override Color TextForeground
        {
            get
            {
                if (status == statusValid)
                    return Color.Black;
                else if (status == statusFlashing)
                    return Color.White;
                else if (status == statusError)
                    return Color.Red;
                else
                {
                    if (isSelected)
                    {
                        return Color.DarkGray;
                    }
                    else
                        return Color.Gray;
                }
            }
        }

        public override Color TextBackground
        {
            get
            {
                if (status == statusFlashing)
                    return Color.Black;
                else if (itsSketchPad.IsLocked)
                    return Color.White;
                else
                {
                    if (isSelected)
                    {
                        return Color.Gray;
                    }
                    else
                        return Color.LightGray;
                }
            }
        }

        public Color FrameColor
        {
            get
            {
                if (status == statusInvalid)
                {
                    if (isSelected)
                    {
                        return Color.DarkGray;
                    }
                    else
                        return Color.Gray;
                }
                else
                    return Color.Black;
            }
        }

        public override bool isMultiline
        {
            get
            {
                return true;
            }
        }

		// ----------------------------------------
		// Paint stuff
		// ----------------------------------------
		
		public override void Paint(Graphics g)
		{
			int x = X;
			int y = Y;
			int w = Width;
			int h = Height;
			
			Color color = TextBackground;
			
			if (itsSketchPad.IsLocked)
                g.FillRectangle(new SolidBrush(color), x + 1, y + 1, w - 1, h - 2);
			else
			{
				//UNDONE: Method 'java.awt.Graphics.fill3DRect' was converted to 'System.Drawing.Graphics.FillRectangle' which has a different behavior. 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="jlca1073_javaawtGraphicsfill3DRect_int_int_int_int_boolean"'
                g.FillRectangle(new SolidBrush(color), x, y + 1, w, h - 2);
			}
			
			color = FrameColor;
            g.DrawLine(new Pen(color), x, y, x + w - 1, y);
            g.DrawLine(new Pen(color), x, y, x, y + h / 4);
            g.DrawLine(new Pen(color), x, y + h - 1, x + minWidth, y + h - 1);
            g.DrawLine(new Pen(color), x, y + h - 1, x, y + h - 1 - h / 4);
			
			DrawContent(g);
			
			paintInlets(g);
			paintOutlets(g);
		}
		
		public override void UpdatePaint(Graphics g)
		{
            int x = X;
            int y = Y;
            int w = Width;
            int h = Height;

            Color color = TextBackground;
            g.FillRectangle(new SolidBrush(color), x + 1, y + 1, w - 1, h - 2);

            color = FrameColor;
            g.DrawLine(new Pen(color), x, y, x + w - 1, y);
            g.DrawLine(new Pen(color), x, y, x, y + cornerSize / 3);
            g.DrawLine(new Pen(color), x, y + h - 1, x + cornerSize, y + h - 1);
            g.DrawLine(new Pen(color), x, y + h - 1, x, y + h - 1 - cornerSize / 3);
			
			DrawContent(g);
		}

	}
}