# -*- mode: perl; coding: utf-8 -*-
# Keitairc::ClientInfo
# $Id: ClientInfo.pm,v 1.6 2008-06-29 09:20:49 morimoto Exp $
# $Source: /home/ishikawa/work/keitairc/tmp/keitairc/lib/Keitairc/ClientInfo.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::ClientInfo;
use strict;
use warnings;

################################################################
sub new{
	my $proto = shift;
	my $arg = shift;
	my $me = {};

	for my $key (keys %{$arg->{_headers}}){
		my $ukey = $key;
		$ukey =~ s/-/_/g;
		$me->{header}->{$ukey} = $arg->{_headers}->{$key};
	}

	if(defined $me->{header}->{Cookie}){
		for my $set (split(/; */, $me->{header}->{Cookie})){
			my ($name, $value) = split(/=/, $set);
			$value =~ s/%([0-9A-Fa-f]{2})/pack('C', hex($1))/eg;
			$me->{cookie}->{$name} = $value;
		}
	}

        bless $me;
	$me->{serial_key} = $me->serial_key();
	$me;
}

################################################################
sub user_agent{
	my $me = shift;
	$me->{header}->{user_agent};
}

################################################################
sub is_ezweb{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^KDDI-/;
}

################################################################
sub is_docomo{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^DoCoMo/;
}

################################################################
sub is_ipod{
	my $me = shift;
	$me->{header}->{user_agent} =~ /(iPod|iPhone)/;
}

################################################################
sub is_softbank{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^(SoftBank|Vodafone|J-PHONE|MOT-)/;
}

################################################################
sub is_emobile{
	my $me = shift;
	$me->is_emobile_mobilebrowser() + $me->is_emobile_openbrowser();
}

################################################################
sub is_emobile_mobilebrowser{
	my $me = shift;
	$me->{header}->{user_agent} =~ /^emobile/;
}

################################################################
sub is_emobile_openbrowser{
	my $me = shift;
	# http://developer.emnet.ne.jp/useragent.html
	$me->{header}->{user_agent} =~ /(H11T; like Gecko|\) S11HT$)/;
}

################################################################
sub is_mobile{
	my $me = shift;
	$me->is_ezweb() + $me->is_docomo()
		+ $me->is_softbank() + $me->is_emobile_mobilebrowser();
}

################################################################
sub softbank_serial{
	my $me = shift;
	if($me->is_softbank()){
		if($me->{header}->{user_agent} =~ m|/(SN[0-9A-Z]+)|){
			return $1;
		}
	}
}

################################################################
sub docomo_foma_icc{
	my $me = shift;
	if($me->is_docomo()){
		# NTT DoCoMoのFOMA端末製造番号 (15桁のユニークな英数字) および
		# FOMAカード製造番号 (20桁のユニークな英数字)
		# http://www.nttdocomo.co.jp/service/imode/make/content/html/tag/utn.html
		# 実際にはlower caseも使われているようなので注意
		# DoCoMo/2.0 P703imyu(c100;TB;W30H15)
		# DoCoMo/2.0 P703imyu(c100;TB;W30H15;ser12345ABCDE12345;icc12345ABCDE12345abcde)
		if($me->{header}->{user_agent} =~ /;(icc[0-9a-zA-Z]{20})/){
			return $1;
		}
	}
}

################################################################
sub subscribe_id{
	my $me = shift;
	$me->{header}->{x_up_subno};
}

################################################################
sub userid{
	my $me = shift;
	$me->{header}->{x_em_uid};
}

################################################################
sub serial_key{
	my $me = shift;
	if($me->is_softbank()){
		return $me->softbank_serial();
	}
	if($me->is_ezweb()){
		return $me->subscribe_id();
	}
	if($me->is_emobile()){
		return $me->userid();
	}
}

################################################################
# Cookieを扱えるかどうか
# とりあえず Cookie を確実に扱えない DoCoMo を判定してるだけ
sub cookie_available{
	my $me = shift;
	unless($me->is_docomo()){
		return 1;
	}
}

1;
