# -*- mode: perl; coding: utf-8 -*-
# Keitairc::Config
# $Id: Config.pm,v 1.16.2.1 2008-07-20 02:22:32 morimoto Exp $
# $Source: /home/ishikawa/work/keitairc/tmp/keitairc/lib/Keitairc/Config.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::Config;
use AppConfig qw(:argcount);
use Cwd;
use strict;
use warnings;
our @ISA = qw(AppConfig);

################################################################
sub new{
	my ($class, $version, @argv) = @_;
	my $me = $class->SUPER::new(
		{
			CASE => 1,
			GLOBAL => {
				ARGCOUNT => ARGCOUNT_ONE,
			}
		},
		qw(irc_nick irc_username irc_desc
		   irc_server irc_port irc_password
		   irc_keyword irc_charset
		   au_subscriber_id au_pcsv
		   docomo_foma_icc docomo_imodeid
		   softbank_serial_key emobile_userid
		   use_cookie cookie_ttl session_ttl
		   web_port web_title web_lines web_root
		   web_username web_password web_host web_charset
		   fontsize mobile_fontsize
		   show_newmsgonly show_joinleave show_console
		   ping_delay reconnect_delay config
		   smtp_server smtp_from smtp_to debug use_iui
		   version daemonize pid_dir pid_file
		   template_dir plugin_dir public_dir
		   reverse_message reverse_recent reverse_unread)
		);

	# set default values
	$me->version($version);
	$me->irc_desc('keitairc');
	$me->irc_port(6667);
	$me->irc_charset('iso-2022-jp-1');
	$me->web_port(8080);
	$me->web_title('keitairc');
	$me->web_lines(100);
	$me->web_root('/');
	$me->web_charset('shiftjis');
	$me->ping_delay(30);
	$me->reconnect_delay(10);
	$me->cookie_ttl(86400 * 3);  # 3 days
	$me->session_ttl(60 * 30);  # 30 min
	$me->pid_dir('/var/run');
	$me->pid_file('keitairc.pid');
	$me->plugin_dir(getcwd() . '/lib/plugins:/usr/share/keitairc/lib/plugins');
	$me->template_dir(getcwd() . '/lib/templates:/usr/share/keitairc/lib/templates');
	$me->public_dir(getcwd() . '/lib/public:/usr/share/keitairc/lib/public');
	$me->reverse_message(1);
	$me->reverse_recent(1);
	$me->reverse_unread(1);
	$me->show_joinleave(1);
	$me->fontsize('+0');
	$me->mobile_fontsize(-1);
	$me->debug(0);

	$me->file('/etc/keitairc');
	$me->file($ENV{HOME} . '/.keitairc');
	$me->args(\@argv);

	if(defined $me->config() && -r $me->config()){
		$me->file($me->config());
	}

	if(defined $me->show_newmsgonly()){
		::log('show_newmsgonly has obsoleted from keitairc 2.0');
	}

	if(defined $me->web_username()){
		::log('web_username has obsoleted from keitairc 2.0');
	}

	if(defined $me->use_cookie()){
		::log('use_cookie has obsoleted from keitairc 2.0');
	}

	if(defined $me->au_pcsv()){
		::log('au_pcsv has obsoleted from keitairc 2.0');
	}

	unless(length $me->irc_nick()){
		::log_die('irc_nick does not specified');
	}

	unless(length $me->irc_username()){
		::log_die('irc_username does not specified');
	}

	unless(length $me->irc_server()){
		::log_die('irc_server does not specified');
	}

	unless(length $me->web_port()){
		::log_die('web_port does not specified');
	}

	unless(length $me->web_host()){
		::log_die('web_host does not specified');
	}

	unless(length $me->web_password()){
		::log_die('web_password does not specified');
	}

	$me;
}

################################################################
sub file{
	my $me = shift;
	my $file = shift;
	if(-r $file){
		$me->SUPER::file($file);
		::log("Loaded configuration file: $file");
		return;
	}
	::log("$file does not exist");
}

1;
