/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Friend;
import com.skype.Group;
import com.skype.SkypeException;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;

public final class ContactList {
    ContactList() {
    }

    public Friend[] getAllFriends() throws SkypeException {
        try {
            String string = "USERS ";
            String string2 = Connector.getInstance().execute("SEARCH FRIENDS", string);
            Utils.checkError(string2);
            String string3 = string2.substring(string.length());
            String[] stringArray = Utils.convertToArray(string3);
            Friend[] friendArray = new Friend[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                friendArray[i] = User.getFriendInstance(stringArray[i]);
            }
            return friendArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public Friend[] getAllUserWaitingForAuthorization() throws SkypeException {
        try {
            String string = "USERS ";
            String string2 = Connector.getInstance().execute("SEARCH USERSWAITINGMYAUTHORIZATION", string);
            Utils.checkError(string2);
            String string3 = string2.substring(string.length());
            String[] stringArray = Utils.convertToArray(string3);
            Friend[] friendArray = new Friend[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                friendArray[i] = User.getFriendInstance(stringArray[i]);
            }
            return friendArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public Friend getFriend(String string) throws SkypeException {
        Utils.checkNotNull(string, "skypeId");
        for (Friend friend : this.getAllFriends()) {
            if (!string.equals(friend.getId())) continue;
            return friend;
        }
        return null;
    }

    public Group[] getAllSystemGroups() throws SkypeException {
        return this.getAllGroups("HARDWIRED");
    }

    public Group getSystemGroup(Group.Type type) throws SkypeException {
        if (type == Group.Type.CUSTOM_GROUP) {
            throw new IllegalArgumentException("custom type is not supported (use getAllGroups method to resolve)");
        }
        for (Group group : this.getAllSystemGroups()) {
            if (group.getType() != type) continue;
            return group;
        }
        return null;
    }

    public Group[] getAllGroups() throws SkypeException {
        return this.getAllGroups("CUSTOM");
    }

    private Group[] getAllGroups(String string) throws SkypeException {
        try {
            String string2 = "GROUPS ";
            String string3 = Connector.getInstance().execute("SEARCH GROUPS " + string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length());
            String[] stringArray = Utils.convertToArray(string4);
            Group[] groupArray = new Group[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                groupArray[i] = Group.getInstance(stringArray[i]);
            }
            return groupArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public Group getGroup(String string) throws SkypeException {
        Utils.checkNotNull(string, "displayName");
        for (Group group : this.getAllGroups()) {
            if (!string.equals(group.getDisplayName())) continue;
            return group;
        }
        return null;
    }

    public Group addGroup(String string) throws SkypeException {
        try {
            String string2 = "GROUP ";
            String string3 = Connector.getInstance().execute("CREATE GROUP " + string, string2).substring(string2.length());
            Utils.checkError(string3);
            String string4 = string3.substring(0, string3.indexOf(32));
            return Group.getInstance(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public Friend addFriend(User user, String string) throws SkypeException {
        return this.addFriend(user.getId(), string);
    }

    public Friend addFriend(String string, String string2) throws SkypeException {
        Friend friend = Friend.getFriendInstance(string);
        friend.askForAuthorization(string2);
        return friend;
    }

    public void removeFriend(Friend friend) throws SkypeException {
        friend.removeFromContactList();
    }

    public void removeGroup(Group group) throws SkypeException {
        group.dispose();
    }
}

