/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.util.HashMap;
import java.util.Map;

public final class Group
extends SkypeObject {
    private static final Map<String, Group> groups = new HashMap<String, Group>();
    private String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Group getInstance(String string) {
        Map<String, Group> map = groups;
        synchronized (map) {
            if (!groups.containsKey(string)) {
                groups.put(string, new Group(string));
            }
            return groups.get(string);
        }
    }

    private Group(String string) {
        this.id = string;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Group) {
            return this.getId().equals(((Group)object).getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public void addFriend(Friend friend) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " ADDUSER " + friend.getId());
    }

    public void addPSTN(String string) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " ADDUSER " + string);
    }

    public void removeFriend(Friend friend) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " REMOVEUSER " + friend.getId());
    }

    public void removePSTN(String string) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " REMOVEUSER " + string);
    }

    public void changeFriendDisplayName(Friend friend, String string) throws SkypeException {
        friend.setDisplayName(string);
    }

    public void changePSTNDisplayName(String string, String string2) throws SkypeException {
        Utils.executeWithErrorCheck("SET USER " + string + " DISPLAYNAME " + string2);
    }

    public Friend[] getAllFriends() throws SkypeException {
        String[] stringArray = Utils.convertToArray(this.getProperty("USERS"));
        Friend[] friendArray = new Friend[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            friendArray[i] = Skype.getContactList().getFriend(stringArray[i]);
        }
        return friendArray;
    }

    public boolean hasFriend(Friend friend) throws SkypeException {
        for (Friend friend2 : this.getAllFriends()) {
            if (!friend.equals(friend2)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("VISIBLE"));
    }

    public boolean isExpanded() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("EXPANDED"));
    }

    public String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public void setDisplayName(String string) throws SkypeException {
        this.setProperty("DISPLAYNAME", string);
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("GROUP", this.getId(), string);
    }

    private void setProperty(String string, String string2) throws SkypeException {
        Utils.setProperty("GROUP", this.getId(), string, string2);
    }

    public void dispose() throws SkypeException {
        try {
            String string = Connector.getInstance().execute("DELETE GROUP " + this.getId(), "DELETED GROUP ");
            Utils.checkError(string);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ALL_USERS,
        ALL_FRIENDS,
        SKYPE_FRIENDS,
        SKYPEOUT_FRIENDS,
        ONLINE_FRIENDS,
        UNKNOWN_OR_PENDINGAUTH_FRIENDS,
        RECENTLY_CONTACTED_USERS,
        USERS_WAITING_MY_AUTHORIZATION,
        USERS_AUTHORIZED_BY_ME,
        USERS_BLOCKED_BY_ME,
        UNGROUPED_FRIENDS,
        CUSTOM_GROUP,
        SHARED_GROUP,
        PROPOSED_SHARED_GROUP;

    }
}

