/*
 * Decompiled with CFR 0.152.
 */
package com.spinn3r.log5j;

import java.util.Formatter;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;

public class Logger
extends org.apache.log4j.Logger {
    private static ThreadLocal<Formatter> formatterCache = new ThreadLocal<Formatter>(){

        @Override
        protected synchronized Formatter initialValue() {
            return new Formatter();
        }
    };
    private static final LoggerFactory loggerFactory = new LoggerFactory(){

        public Logger makeNewLoggerInstance(String name) {
            return new Logger(name);
        }
    };

    Logger(String name) {
        super(name);
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLoggerImpl(clazz.getName());
    }

    public static Logger getLogger() {
        String name = new Exception().getStackTrace()[1].getClassName();
        return Logger.getLoggerImpl(name);
    }

    private static Logger getLoggerImpl(String name) {
        Logger log = (Logger)org.apache.log4j.Logger.getLogger((String)name, (LoggerFactory)loggerFactory);
        return log;
    }

    public void info(String format, Object ... args) {
        if (!this.isInfoEnabled()) {
            return;
        }
        super.info((Object)Logger.sprintf(format, args));
    }

    public void info(String format, Throwable t, Object ... args) {
        if (!this.isInfoEnabled()) {
            return;
        }
        super.info((Object)Logger.sprintf(format, args), t);
    }

    public void debug(String format, Object ... args) {
        if (!this.isDebugEnabled()) {
            return;
        }
        super.debug((Object)Logger.sprintf(format, args));
    }

    public void debug(String format, Throwable t, Object ... args) {
        if (!this.isDebugEnabled()) {
            return;
        }
        super.debug((Object)Logger.sprintf(format, args), t);
    }

    public void error(String format, Object ... args) {
        if (!this.isEnabledFor(Priority.ERROR)) {
            return;
        }
        super.error((Object)Logger.sprintf(format, args));
    }

    public void error(String format, Throwable t, Object ... args) {
        if (!this.isEnabledFor(Priority.ERROR)) {
            return;
        }
        super.error((Object)Logger.sprintf(format, args), t);
    }

    public void fatal(String format, Object ... args) {
        if (!this.isEnabledFor(Priority.FATAL)) {
            return;
        }
        super.fatal((Object)Logger.sprintf(format, args));
    }

    public void fatal(String format, Throwable t, Object ... args) {
        if (!this.isEnabledFor(Priority.FATAL)) {
            return;
        }
        super.fatal((Object)Logger.sprintf(format, args), t);
    }

    public void warn(String format, Object ... args) {
        if (!this.isEnabledFor(Priority.WARN)) {
            return;
        }
        super.warn((Object)Logger.sprintf(format, args));
    }

    public void warn(String format, Throwable t, Object ... args) {
        if (!this.isEnabledFor(Priority.WARN)) {
            return;
        }
        super.warn((Object)Logger.sprintf(format, args), t);
    }

    public static String sprintf(String format, Object ... args) {
        Formatter f = Logger.getFormatter();
        f.format(format, args);
        StringBuilder sb = (StringBuilder)f.out();
        String message = sb.toString();
        sb.setLength(0);
        return message;
    }

    private static Formatter getFormatter() {
        return formatterCache.get();
    }
}

