/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Call;
import com.skype.CallAdapter;
import com.skype.CommandFailedException;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.TestData;
import com.skype.TestUtils;
import java.util.Date;
import junit.framework.TestCase;

public class CallAPITest
extends TestCase {
    public void testCallAndFinish() throws Exception {
        TestUtils.showMessageDialog("Please, check " + TestData.getFriendId() + " will receive a call and it will be finished after two seconds?");
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        Thread.sleep(2000L);
        call.finish();
        TestUtils.showCheckDialog(String.valueOf(TestData.getFriendId()) + " has received a call and it was finished after two seconds?");
    }

    public void testFinishEndedCall() throws Exception {
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        call.finish();
        Thread.sleep(1000L);
        try {
            call.finish();
        }
        catch (CommandFailedException e) {
            CallAPITest.assertEquals((int)24, (int)e.getCode());
            CallAPITest.assertEquals((String)"Cannot hangup inactive call", (String)e.getMessage());
        }
    }

    public void testHoldAndResume() throws Exception {
        TestUtils.showMessageDialog("Please, start a talking with " + TestData.getFriendId() + " in ten seconds after starting a call.");
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        Thread.sleep(10000L);
        TestUtils.showMessageDialog("Please, check 2 seconds suspending, 2 seconds talking and finishing.");
        call.hold();
        Thread.sleep(2000L);
        call.resume();
        Thread.sleep(2000L);
        call.finish();
        TestUtils.showCheckDialog("You have gotton a 2 seconds suspending, and 2 seconds talking?");
    }

    public void testCallProperty() throws Exception {
        Date startTime = new Date();
        TestUtils.showMessageDialog("Please, start a talking with " + TestData.getFriendId() + " and finish in ten seconds after starting a call.");
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        Thread.sleep(10000L);
        Date endTime = new Date();
        CallAPITest.assertTrue((call.getStartTime().getTime() - startTime.getTime() <= endTime.getTime() - startTime.getTime() ? 1 : 0) != 0);
        CallAPITest.assertTrue(((long)call.getDuration() <= endTime.getTime() - startTime.getTime() ? 1 : 0) != 0);
        CallAPITest.assertEquals((String)TestData.getFriendId(), (String)call.getPartnerId());
        CallAPITest.assertEquals((String)TestData.getFriendDisplayName(), (String)call.getPartnerDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallReceived() throws Exception {
        final Object wait = new Object();
        final Call[] result = new Call[1];
        Skype.addCallListener(new CallAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void callReceived(Call call) throws SkypeException {
                Object object = wait;
                synchronized (object) {
                    wait.notify();
                }
                result[0] = call;
            }
        });
        TestUtils.showMessageDialog("Please, request " + TestData.getFriendId() + " to call me, receive the call, and finish.");
        Object object = wait;
        synchronized (object) {
            wait.wait();
        }
        CallAPITest.assertEquals((String)TestData.getFriendId(), (String)result[0].getPartnerId());
    }
}

