/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.CommandFailedException;
import com.skype.NotAttachedException;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.TimeOutException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class Utils {
    static void convertToSkypeException(ConnectorException e) throws SkypeException {
        SkypeException r = e instanceof com.skype.connector.NotAttachedException ? new NotAttachedException() : (e instanceof TimeOutException ? new com.skype.TimeOutException(e.getMessage()) : new SkypeException(e.getMessage()));
        r.initCause(e);
        throw r;
    }

    static void checkError(String response) throws SkypeException {
        if (response == null) {
            return;
        }
        if (response.startsWith("ERROR ")) {
            throw new CommandFailedException(response);
        }
    }

    static String getPropertyWithCommandId(String type, String id, String name) throws SkypeException {
        try {
            String command = "GET " + type + " " + id + " " + name;
            String responseHeader = String.valueOf(type) + " " + id + " " + name + " ";
            String response = Connector.getInstance().executeWithId(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static String getProperty(String type, String id, String name) throws SkypeException {
        try {
            String command = "GET " + type + " " + id + " " + name;
            String responseHeader = String.valueOf(type) + " " + id + " " + name + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static String getProperty(String type, String name) throws SkypeException {
        try {
            String command = "GET " + type + " " + name;
            String responseHeader = String.valueOf(type) + " " + name + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static String getProperty(String name) throws SkypeException {
        try {
            String command = "GET " + name + " ";
            String responseHeader = String.valueOf(name) + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static void setProperty(String type, String id, String name, String value) throws SkypeException {
        try {
            String command = "SET " + type + " " + id + " " + name + " " + value;
            String responseHeader = String.valueOf(type) + " " + id + " " + name + " " + value;
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void setProperty(String type, String name, String value) throws SkypeException {
        try {
            String command = "SET " + type + " " + name + " " + value;
            String responseHeader = String.valueOf(type) + " " + name + " " + value;
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void setProperty(String name, String value) throws SkypeException {
        try {
            String command = "SET " + name + " " + value;
            String responseHeader = String.valueOf(name) + " " + value;
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void executeWithErrorCheck(String command) throws SkypeException {
        try {
            String response = Connector.getInstance().execute(command);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException("The " + name + " must not be null.");
        }
    }

    static String[] convertToArray(String listString) {
        if ("".equals(listString)) {
            return new String[0];
        }
        return listString.split(", ");
    }

    static String convertToCommaSeparatedString(String[] array) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(array[i]);
            ++i;
        }
        return builder.toString();
    }

    static Date parseUnixTime(String time) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(Long.parseLong(time) * 1000L);
        calendar.setTimeZone(TimeZone.getDefault());
        return calendar.getTime();
    }

    static void handleUncaughtException(Throwable e, SkypeExceptionHandler exceptionHandler) {
        if (exceptionHandler != null) {
            exceptionHandler.uncaughtExceptionHappened(e);
            return;
        }
        Skype.handleUncaughtException(e);
    }

    private Utils() {
    }
}

