/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.win32;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorUtils;
import java.io.File;

public final class Win32Connector
extends Connector {
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int ATTACH_API_AVAILABLE = 32769;
    private static final String LIBFILENAME = "JNIConnector.dll";
    private static Win32Connector myInstance_ = null;
    private Thread thread_ = null;

    public static synchronized Connector getInstance() {
        if (myInstance_ == null) {
            myInstance_ = new Win32Connector();
        }
        return myInstance_;
    }

    private Win32Connector() {
    }

    public String getInstalledPath() {
        return this.jni_getInstalledPath();
    }

    protected void initialize(int timeout) {
        block3: {
            try {
                System.loadLibrary("JNIConnector");
            }
            catch (Throwable throwable) {
                if (ConnectorUtils.checkLibraryInPath(LIBFILENAME)) break block3;
                ConnectorUtils.extractFromJarToTemp(LIBFILENAME);
                String tmpDir = System.getProperty("java.io.tmpdir");
                if (!tmpDir.endsWith("" + File.separatorChar)) {
                    tmpDir = String.valueOf(tmpDir) + File.separatorChar;
                }
                System.load(String.valueOf(tmpDir) + LIBFILENAME);
            }
        }
        this.jni_init();
        this.thread_ = new Thread(new Runnable(){

            public void run() {
                Win32Connector.this.jni_windowProc();
            }
        }, "SkypeBridge WindowProc Thread");
        this.thread_.setDaemon(true);
        this.thread_.start();
    }

    protected Connector.Status connect(int timeout) throws ConnectorException {
        try {
            while (true) {
                Connector.Status status;
                this.jni_connect();
                long start = System.currentTimeMillis();
                if ((long)timeout <= System.currentTimeMillis() - start) {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
                if ((status = this.getStatus()) != Connector.Status.PENDING_AUTHORIZATION && status != Connector.Status.NOT_RUNNING) {
                    return status;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new ConnectorException("Trying to connect was interrupted.", e);
        }
    }

    protected void sendApplicationName(String applicationName) throws ConnectorException {
        String command = "NAME " + applicationName;
        this.execute(command, new String[]{command}, false);
    }

    public void jni_onAttach(int status) {
        switch (status) {
            case 1: {
                this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                break;
            }
            case 0: {
                this.setStatus(Connector.Status.ATTACHED);
                break;
            }
            case 2: {
                this.setStatus(Connector.Status.REFUSED);
                break;
            }
            case 3: {
                this.setStatus(Connector.Status.NOT_AVAILABLE);
                break;
            }
            case 32769: {
                this.setStatus(Connector.Status.API_AVAILABLE);
                break;
            }
            default: {
                this.setStatus(Connector.Status.NOT_RUNNING);
            }
        }
    }

    public void jni_onSkypeMessage(String message) {
        this.fireMessageReceived(message);
    }

    protected void disposeImpl() {
        throw new UnsupportedOperationException("WindowsConnector#disposeImpl() is not implemented yet.");
    }

    protected void sendCommand(String command) {
        this.jni_sendMessage(command);
    }

    private native void jni_init();

    private native void jni_windowProc();

    private native void jni_sendMessage(String var1);

    private native void jni_connect();

    private native String jni_getInstalledPath();
}

