/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.windows;

import com.skype.TestUtils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorStatusEvent;
import com.skype.connector.windows.WindowsConnector;
import junit.framework.TestCase;

public final class WindowsConnectorTest
extends TestCase {
    public void testAttachedAfterTryingToConnect() throws Exception {
        TestUtils.showMessageDialog("Open [Tools - Options - Privacy - Manage other programs' access to Skype] and ensure that there is no java application (JAVAW.EXE or JAVA.EXE), please.");
        TestUtils.showMessageDialog("Select [Another program wants to use Skype - Allow this program to use Skype] when Skype shows the authorization dialog, please.");
        WindowsConnectorTest.assertEquals((Object)((Object)Connector.Status.ATTACHED), (Object)((Object)WindowsConnector.getInstance().connect()));
    }

    public void testRefusedAfterTryingToConnect() throws Exception {
        TestUtils.showMessageDialog("Open [Tools - Options - Privacy - Manage other programs' access to Skype] and ensure that there is no java application (JAVAW.EXE or JAVA.EXE), please.");
        TestUtils.showMessageDialog("Select [Another program wants to use Skype - Do not allow this program to use Skype] when Skype shows the authorization dialog, please.");
        WindowsConnectorTest.assertEquals((Object)((Object)Connector.Status.REFUSED), (Object)((Object)WindowsConnector.getInstance().connect()));
        TestUtils.showMessageDialog("Open [Tools - Options - Privacy - Manage other programs' access to Skype] and ensure that there is no java application (JAVAW.EXE or JAVA.EXE) for next test, please.");
    }

    public void testNotAvailableAfterTryingToConnect() throws Exception {
        TestUtils.showMessageDialog("Sign out from Skype, please.");
        WindowsConnectorTest.assertEquals((Object)((Object)Connector.Status.NOT_AVAILABLE), (Object)((Object)WindowsConnector.getInstance().connect()));
        final boolean[] available = new boolean[1];
        AbstractConnectorListener listener = new AbstractConnectorListener(){

            public void statusChanged(ConnectorStatusEvent event) {
                Connector.Status status = event.getStatus();
                if (status == Connector.Status.API_AVAILABLE) {
                    available[0] = true;
                }
            }
        };
        WindowsConnector.getInstance().addConnectorListener(listener, false);
        TestUtils.showMessageDialog("Sign in Skype, please.");
        WindowsConnectorTest.assertTrue((boolean)available[0]);
    }

    public void testNotRunnigAfterTryingToConnect() throws Exception {
        TestUtils.showMessageDialog("Shut down Skype, please.");
        WindowsConnectorTest.assertEquals((Object)((Object)Connector.Status.NOT_RUNNING), (Object)((Object)WindowsConnector.getInstance().connect()));
        TestUtils.showMessageDialog("Launch Skype for next test, please.");
    }

    public void testGetInstalledPath() {
        WindowsConnectorTest.assertEquals((String)"C:\\Program Files\\Skype\\Phone\\Skype.exe", (String)WindowsConnector.getInstance().getInstalledPath());
    }
}

