/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;

public class IncludeAction
extends Action {
    private static final String INCLUDED_TAG = "included";
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private SaxEventRecorder recorder = new SaxEventRecorder();

    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        SaxEvent last;
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        String attributeInUse = null;
        if (!this.checkAttributes(fileAttribute, urlAttribute, resourceAttribute)) {
            return;
        }
        InputStream in = null;
        if (!OptionHelper.isEmpty(fileAttribute)) {
            attributeInUse = ec.subst(fileAttribute);
            in = this.getInputStreamByFilePath(attributeInUse);
        }
        if (!OptionHelper.isEmpty(urlAttribute)) {
            attributeInUse = ec.subst(urlAttribute);
            in = this.getInputStreamByUrl(attributeInUse);
        }
        if (!OptionHelper.isEmpty(resourceAttribute)) {
            attributeInUse = ec.subst(resourceAttribute);
            in = this.getInputStreamByResource(attributeInUse);
        }
        try {
            if (in != null) {
                this.parseAndRecord(in);
                in.close();
            }
        }
        catch (JoranException e) {
            this.addError("Error while parsing  " + attributeInUse, e);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.recorder.saxEventList.size() == 0) {
            return;
        }
        SaxEvent first = this.recorder.saxEventList.get(0);
        if (first != null && first.qName.equalsIgnoreCase(INCLUDED_TAG)) {
            this.recorder.saxEventList.remove(0);
        }
        if ((last = this.recorder.saxEventList.get(this.recorder.saxEventList.size() - 1)) != null && last.qName.equalsIgnoreCase(INCLUDED_TAG)) {
            this.recorder.saxEventList.remove(this.recorder.saxEventList.size() - 1);
        }
        ec.getJoranInterpreter().addEvents(this.recorder.saxEventList);
    }

    private boolean checkAttributes(String fileAttribute, String urlAttribute, String resourceAttribute) {
        int count = 0;
        if (!OptionHelper.isEmpty(fileAttribute)) {
            ++count;
        }
        if (!OptionHelper.isEmpty(urlAttribute)) {
            ++count;
        }
        if (!OptionHelper.isEmpty(resourceAttribute)) {
            ++count;
        }
        if (count == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (count > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (count == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count + "] is not expected");
    }

    private InputStream getInputStreamByFilePath(String pathToFile) {
        try {
            return new FileInputStream(pathToFile);
        }
        catch (IOException ioe) {
            String errMsg = "File [" + pathToFile + "] does not exist.";
            this.addError(errMsg, ioe);
            return null;
        }
    }

    private InputStream getInputStreamByUrl(String urlAttribute) {
        URL url;
        try {
            url = new URL(urlAttribute);
        }
        catch (MalformedURLException mue) {
            String errMsg = "URL [" + urlAttribute + "] is not well formed.";
            this.addError(errMsg, mue);
            return null;
        }
        return this.openURL(url);
    }

    InputStream openURL(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            String errMsg = "Failed to open [" + url.toString() + "]";
            this.addError(errMsg, e);
            return null;
        }
    }

    private InputStream getInputStreamByResource(String resourceAttribute) {
        URL url = Loader.getResourceByTCL(resourceAttribute);
        if (url == null) {
            String errMsg = "Could not find resource corresponding to [" + resourceAttribute + "]";
            this.addError(errMsg);
            return null;
        }
        return this.openURL(url);
    }

    private void parseAndRecord(InputStream inputSource) throws JoranException {
        this.recorder.setContext(this.context);
        this.recorder.recordEvents(inputSource);
    }

    public void end(InterpretationContext ec, String name) throws ActionException {
    }
}

