        MODULE PROFIT_GLOBAL
C
        PUBLIC
C
C       PROFIT GLOBAL MODULE
C
C       MAIN DATA ARRAYS FOR PROFIT
C       TRACK STOCK NAME
        CHARACTER*80 PROFITNAMES
        DIMENSION PROFITNAMES(:)
        ALLOCATABLE :: PROFITNAMES

C       TRACK STOCK TICKER
        CHARACTER*8 PROFITTICKER
        DIMENSION PROFITTICKER(:)
        ALLOCATABLE :: PROFITTICKER
C
C       ARRAY TO TRACK NUMBER OF VALID ENTRIES FOR EACH ISSUE
        INTEGER PROFITENTRIES,KENTRIES
        DIMENSION PROFITENTRIES(:,:)
C       FIRST DIMENSION GOES FROM 1 TO MAX NO OF ISSUES, SECOND GOES 1:2
C       WHERE 1 IS THE STARTING RECORD FOR THAT ISSUE AND 2 IS THE ENDING RECORD OF THAT ISSUE
        ALLOCATABLE :: PROFITENTRIES

C       ARRAY TO TRACK STOCK DATA (PRIMARY AND DERIVED)
C       DIMENSION 1 (J) GOES FROM 1 TO MAXIMUM NUMBER OF DAYS IN THE DATABASE
C       DIMENSION 2 (K) GOES FROM 1 TO 100
        INTEGER IREC,JREC1,JREC2
C        K=1  : PRICE HI
C        K=2  : PRICE LO
C        K=3  : PRICE CLOSE
C        K=4  : SHORT MOVING AVERAGE
C        K=5  : MEDIUM MOVING AVERAGE
C        K=6  : LONG MOVING AVERAGE
C        K=7  : SHORT OSCILLATOR
C        K=8  : LONG OSCILLATOR
C        K=9  : SHORT TREND
C        K=10 : LONG TREND
C        K=11 : SPREAD
C        K=12 : VOLUME
C        K=13 : DATE YYYMMDD
C        K=14 : HI PRICE        DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=15 : LO PRICE        DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=16 : CLOSING PRICE  DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=17 : SHORT  MOVING AVERAGE DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=18 : MEDIUM MOVING AVERAGE DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=19 : LONG   MOVING AVERAGE DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=20 : SHORT OSCILLATOR DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=21 : LONG  OSCILLATOR DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=22 : SHORT TREND DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=23 : LONG  TREND DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=24 : SPREAD DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=25 : VOLUME DELTA (CURRENT VALUE - PREVIOUS DAYS VALUE), 0.0 FOR FIRST DAY
C        K=26 : NOT USED
C        K=27 TO K=38 ARE THE SECOND DELTAS OF K=14 TO K=25
C        K=40 : JULIAN DAY NUMBER
C        K=41 : JULIAN DAY NUMBER 1ST DELTA
C        K=42 : JULIAN DAY NUMBER 2ND DELTA
C
C        K=43 TO 45 NOT YET USED
C
C        K=46 : OPENING PRICE
C        K=47 : SREC (THE ISSUE NUMBER IN THE PROFIT.DAT FILE)
C        K=48 : IREC (SEQUENTIAL ENTRY NUMBER IN THE PROFIT.DAT FILE)
C        K=49 : JREC (SEQUENTIAL ENTRY FOR THE PARTICULAR ISSUE)
C        K=50 : TOTAL NUMBER OF VALID RECORDS FOR STOCK ITEM I, UPDATED EACH TIME A NEW DAY IS PROCESSED
C        K=51 : SHORT MOVING AVERAGE OF THE SPREAD
C        K=52 : MEDIUM MOVING AVERAGE OF THE SPREAD
C        K=53 : LONG MOVING AVERAGE OF THE SPREAD
C        K=54 TO 100 NOT YET USED
C
C       PROFITFILE TRACKS THE EXISTENCE OF THE FILE PROFIT.DAT. pROFITLOADED TRACKS THE EXISTENCE
C       OF PROFIT DATA LOADED FROM THE PROFIT.DAT FILE
        LOGICAL PROFITFILE,PROFITLOADED
C
C       ASCII FILE TO PASS IN STOCK DATA IS COMMA DELIMITED FILE.
C       EACH ENTRY HAS:
C
C       SYMBOL          CHARACTER*8 (SYM)
C       OPENING PRICE   REAL*8
C       HI PRICE        REAL*8
C       LO PRICE        REAL*8
C       CLOSE PRICE     REAL*8
C       VOLUME          INTEGER*4
C       DATA(YYYMMDD)   INTEGER*4
C       PNAME           CHARACTER*80
C
C
        CHARACTER*8 SYM
        REAL*8 PROFITDATA
        DIMENSION PROFITDATA(:,:)
        ALLOCATABLE :: PROFITDATA
C
C       VARIABLES TO HOLD NUMBER OF DAYS TO BASE SHORT, MEDIUM AND LONG MOVING AVERAGES
        INTEGER SHORT_TIME,MEDIUM_TIME,LONG_TIME,BUY_DELAY,SELL_DELAY
C       (DEFAULTS 5,15,30,5,5)
C
C       MAXI=NUMBER OF RECORDS IN THE PROFIT.DAT FILE (MAX FILE SIZE)
C
C       MAXJ=LARGEST NUMBER OF ENTRIES FOR ANY ONE STOCK (MAX DAYS)
C
C       MAXK=MAXIMUM NUMBER OF ISSUES IN THE PROFIT.DAT FILE
        INTEGER MAXI,MAXJ,MAXK
C
C       BUY SIGNAL IS A POSITIVE DIVERGENCE. THE PRICE IS A LOWER LOW WHILE THE SPREAD IS A HIGHER HIGH
C
C       SELL SIGNAL ID A NEGATIVE DIVERGENCE. THE PRICE IS A HIGHER HIGH WHILE THE SPREAD IS MAKING LOWER HIGHS
C
C       FLAG TO CHECK THAT AN ISSUE IS LOADED BY LOADISSU
        LOGICAL ISSUE_LOADED
C
C
        INTEGER FIRSTDAY,LASTDAY,PDAYS,ENDDAY,STARTDAY
C
C
      END MODULE PROFIT_GLOBAL
