/**
 * @file hal.c
 * @author Shinichiro Nakamura
 */

/*
 * ===============================================================
 * "Natural Tiny Basic (NT-Basic)"
 * "A tiny BASIC interpreter"
 * ---------------------------------------------------------------
 * Hardware abstract layer
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include "hal.h"
#include "lib.h"

int hal_init(void)
{
  return 0;
}

int hal_getc(void)
{
  return getc();
}

int hal_putc(int c)
{
  return putc(c);
}

int hal_read(const unsigned int port, unsigned int *data)
{
  switch (port) {
    case 0:
      *data = hal_getc();
      return 0;
    default:
      *data = 0;
      return 0;
  }
  return -1;
}

int hal_write(const unsigned int port, const unsigned int data)
{
  switch (port) {
    case 0:
      hal_putc(data);
      return 0;
    default:
      return 0;
  }
  return -1;
}

int hal_halt(void)
{
  /*
   * This port uses general libc function.
   * But you need to change this implementation for your embedded system.
   */
  while (1) {
    getc();
  }
  return 0;
}

