#include "defines.h"
#include "kozos.h"
#include "lib.h"
#include "consdrv.h"
#include "rotenc.h"
#include "re.h"
#include "leddrv.h"

/* $B%3%s%=!<%k$X$NJ8;zNs=PNO$r%3%s%=!<%k!&%I%i%$%P$K0MMj$9$k(B */
static void send_write(char *str)
{
  char *p;
  int len;
  len = strlen(str);
  p = kz_kmalloc(len + 2);
  p[0] = '0';
  p[1] = CONSDRV_CMD_WRITE;
  memcpy(&p[2], str, len);
  kz_send(MSGBOX_ID_CONSOUTPUT, len + 2, p);
}

static void send_led_write(int target, int state)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = state ? LEDDRV_CMD_LED_ON : LEDDRV_CMD_LED_OFF;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

static void send_led_toggle(int target)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = LEDDRV_CMD_LED_TOGGLE;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

int rotenc_main(int argc, char *argv[])
{
  re_init();

  uint16 prev = 0, curr = 0;
  while (1) {
    curr = re_read();
    if (curr != prev) {
      int dir = (int)(curr & 0xff) - (int)(prev & 0xff);
      if (dir < 0) {
        if (-32 < dir) {
          send_write("<-\n");
          send_led_toggle(2);
          send_led_write(3, 0);
        }
      } else {
        if (dir < 32) {
          send_write("->\n");
          send_led_write(2, 0);
          send_led_toggle(3);
        }
      }
      prev = curr;
    }
  }

  return 0;
}
