#include "leddrv.h"
#include "led.h"
#include "kozos.h"

/* $B%9%l%C%I$+$i$NMW5a$r=hM}$9$k(B */
static int leddrv_command(char *p)
{
  int cmd = p[0];
  int led = p[1] - '0';
  switch (cmd) {
  case LEDDRV_CMD_LED_ON:
    led_write(led, LedOn);
    break;
  case LEDDRV_CMD_LED_OFF:
    led_write(led, LedOff);
    break;
  case LEDDRV_CMD_LED_TOGGLE:
    led_toggle(led);
    break;
  default:
    break;
  }
  kz_kmfree(p);

  return 0;
}

int leddrv_main(int argc, char *argv[])
{
  int size;
  char *p;

  led_init();
  while (1) {
    kz_recv(MSGBOX_ID_LEDDRIVE, &size, &p);
    leddrv_command(p);
  }

  return 0;
}
