#include "defines.h"
#include "kozos.h"
#include "consdrv.h"
#include "timerdrv.h"
#include "leddrv.h"
#include "lib.h"
#include "sw.h"
#include "lcd.h"
#include "re.h"
#include "pff.h"

/* 󥽡ؤʸϤ򥳥󥽡롦ɥ饤Ф˰ꤹ */
static void send_write(char *str)
{
  char *p;
  int len;
  len = strlen(str);
  p = kz_kmalloc(len + 2);
  p[0] = '0';
  p[1] = CONSDRV_CMD_WRITE;
  memcpy(&p[2], str, len);
  kz_send(MSGBOX_ID_CONSOUTPUT, len + 2, p);
}

/* ޤΥȳϤ򥿥ޡɥ饤Ф˰ꤹ */
static void send_start(int msec)
{
  struct timerreq *req;
  req = kz_kmalloc(sizeof(*req));
  req->id = MSGBOX_ID_TIMEXPIRE;
  req->msec = msec;
  kz_send(MSGBOX_ID_TIMDRIVE, TIMERDRV_CMD_START, (char *)req);
}

static void send_led_write(int target, int state)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = state ? LEDDRV_CMD_LED_ON : LEDDRV_CMD_LED_OFF;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

static void send_led_toggle(int target)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = LEDDRV_CMD_LED_TOGGLE;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

static void die(int code)
{
  puts("die with code 0x");
  putxval(code, 4);
  puts(".\n");
  while (1) { }
}

static int func_fread(void *buf, const uint32 size, void *extobj)
{
  WORD br;
  int rc = pf_read(buf, size, &br);
  return rc ? 1 : 0;
}

static void func_pixel_write(const int x, const int y, const uint8 r, const uint8 g, const uint8 b, void *extobj)
{
  lcd_set_pixel(x, y, 0);
}

int clock_main(int argc, char *argv[])
{
  uint8 val = 0;

  re_init();
  lcd_init();
  sw_init();

  uint16 prev = 0, curr = 0;
  while (1) {
    val = (val + 1) % 101;
    lcd_draw_progressbar(5, 20, 121 - 5, 25, 0, 100, val, 0);

    send_start(10);
    kz_recv(MSGBOX_ID_TIMEXPIRE, NULL, NULL);
    if (sw_read(Sw1)) {
      send_led_write(0, 1);
    } else {
      send_led_toggle(0);
    }

    send_start(10);
    kz_recv(MSGBOX_ID_TIMEXPIRE, NULL, NULL);
    if (sw_read(Sw2)) {
      send_led_write(1, 1);
    } else {
      send_led_toggle(1);
    }

    curr = re_read();
    if (curr != prev) {
      int dir = (int)(curr & 0xff) - (int)(prev & 0xff);
      if (dir < 0) {
        if (-32 < dir) {
          send_write("<-\n");
          send_led_toggle(2);
          send_led_write(3, 0);
        }
      } else {
        if (dir < 32) {
          send_write("->\n");
          send_led_write(2, 0);
          send_led_toggle(3);
        }
      }
      prev = curr;
    }
  }

  return 0;
}
