#include "defines.h"
#include "kozos.h"
#include "interrupt.h"
#include "lib.h"

/* ƥࡦȥ桼εư */
static int start_threads(int argc, char *argv[])
{
  kz_run(consdrv_main,  "consdrv",  1, 0x200, 0, NULL);
  kz_run(command_main,  "command",  8, 0x200, 0, NULL);
  kz_run(timerdrv_main, "timerdrv", 2, 0x100, 0, NULL);
  kz_run(leddrv_main,   "leddrv",   7, 0x100, 0, NULL);
  kz_run(clock_main,    "clock",    9, 0x200, 0, NULL);
  kz_run(remocon_main,  "remocon", 10, 0x100, 0, NULL);

  kz_chpri(15); /* ̤ͥ򲼤ơɥ륹åɤ˰ܹԤ */
  INTR_ENABLE; /* ͭˤ */
  while (1) {
    asm volatile ("sleep"); /* ϥ⡼ɤ˰ܹ */
  }

  return 0;
}

int main(void)
{
  INTR_DISABLE; /* ̵ˤ */

  puts("kozos boot succeed!\n");

  /* OSư */
  kz_start(start_threads, "idle", 0, 0x100, 0, NULL);
  /* ˤäƤʤ */

  return 0;
}
