#!/bin/sh

#
# KOZOS IPC Relationship Visualization Tool (Version 0.0.1)
# Copyright(C) 2012 Shinichiro Nakamura (CuBeatSystems)
#

#
# 定義
#
TARGET_SENDTASK="*.c"
TARGET_RECVTASK="*.c"
KXSEND_TEMPFILE=`mktemp kxsend.XXX`
KZSEND_TEMPFILE=`mktemp kzsend.XXX`
KZRECV_TEMPFILE=`mktemp kzrecv.XXX`
DOTFILE="ipcmap.dot"
IMGFILE="ipcmap.png"

#
# 出力ファイルを空にする
#
echo "" > $DOTFILE

#
# kx_sendとkz_sendとkz_recvの情報を一時ファイルに格納する
#
grep kx_send $TARGET_SENDTASK | \
  sed "s/kx_send(//" | sed "s/[\:,]//g" | sed "s/\.c//g" | \
  awk '{ print "\"" $1 "\"" " -> " "\"" $2 "\"" }' > $KXSEND_TEMPFILE
grep kz_send $TARGET_SENDTASK | \
  sed "s/kz_send(//" | sed "s/[\:,]//g" | sed "s/\.c//g" | \
  awk '{ print "\"" $1 "\"" " -> " "\"" $2 "\"" }' > $KZSEND_TEMPFILE
grep kz_recv $TARGET_RECVTASK | \
  sed "s/kz_recv(//" | sed "s/[\:,]//g" | sed "s/\.c//g" | \
  awk '{ print "\"" $2 "\"" " -> " "\"" $1 "\"" }' > $KZRECV_TEMPFILE

#
# バナー
#
echo "// Generated by KOZOS IPC Relationship Visualization Tool" >> $DOTFILE
echo "// Copyright(C) 2012 Shinichiro Nakamura (CuBeatSystems)" >> $DOTFILE
echo "" >> $DOTFILE

#
# ヘッダ
#
echo "digraph relationship {" >> $DOTFILE
echo "" >> $DOTFILE
echo "  // Global configurations" >> $DOTFILE
echo "  graph [size = \"16.0, 16.0\", label = \"KOZOS IPC Relationship Visualization\", labelloc = t, rankdir = LR];" >> $DOTFILE
echo "" >> $DOTFILE

#
# kx_sendとメッセージボックスの関係を記す
#
echo "  // kx_send" >> $DOTFILE
while read LINE
do
  #
  # kx_sendを使ってMSGBOXに送信している箇所を抽出する
  #
  EVTSND=`echo $LINE | sed "s/\.c//g" | awk '{ print $1 }'`
  MSGBOX=`echo $LINE | awk '{ print $3 }'`
  CNT=`echo $MSGBOX | grep "MSGBOX" | wc -l | awk '{ print $1 }'`
  if [ "$CNT" = "1" ]
  then
      echo "  "$EVTSND" [style = dashed];" >> $DOTFILE
      echo "  "$MSGBOX" [shape = box];" >> $DOTFILE
      echo "  "$LINE";" >> $DOTFILE
  fi
done < $KXSEND_TEMPFILE
echo "" >> $DOTFILE

#
# kz_sendとメッセージボックスの関係を記す
#
echo "  // kz_send" >> $DOTFILE
while read LINE
do
  #
  # kz_sendを使ってMSGBOXに送信している箇所を抽出する
  #
  EVTSND=`echo $LINE | sed "s/\.c//g" | awk '{ print $1 }'`
  MSGBOX=`echo $LINE | awk '{ print $3 }'`
  CNT=`echo $MSGBOX | grep "MSGBOX" | wc -l | awk '{ print $1 }'`
  if [ "$CNT" = "1" ]
  then
      echo "  "$EVTSND" [style = solid];" >> $DOTFILE
      echo "  "$MSGBOX" [shape = box];" >> $DOTFILE
      echo "  "$LINE";" >> $DOTFILE
  fi
done < $KZSEND_TEMPFILE
echo "" >> $DOTFILE

#
# kz_recvとメッセージボックスの関係を記す
#
echo "  // kz_recv" >> $DOTFILE
while read LINE
do
  #
  # kz_recvを使ってMSGBOXから受信している箇所を抽出する
  #
  MSGBOX=`echo $LINE | awk '{ print $1 }'`
  EVTRCV=`echo $LINE | sed "s/\.c//g" | awk '{ print $1 }'`
  CNT=`echo $MSGBOX | grep "MSGBOX" | wc -l | awk '{ print $1 }'`
  if [ "$CNT" = "1" ]
  then
      echo "  "$MSGBOX" [shape = box];" >> $DOTFILE
      echo "  "$EVTRCV" [style = solid];" >> $DOTFILE
      echo "  "$LINE";" >> $DOTFILE
  fi
done < $KZRECV_TEMPFILE
echo "" >> $DOTFILE

#
# テイラー
#
echo "}" >> $DOTFILE
echo "" >> $DOTFILE

#
# 一時ファイルを削除する
#
rm $KXSEND_TEMPFILE
rm $KZSEND_TEMPFILE
rm $KZRECV_TEMPFILE

#
# Graphviz/dotでグラフを描画する
#
dot -T png $DOTFILE -o $IMGFILE

