package com.kurukurupapa.tryandroidui.listactivity;

import com.kurukurupapa.tryandroidui.R;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class ListActivityEx2Adapter extends ArrayAdapter<ListActivityExDto> {
	private static final String TAG = "com.kurukurupapa.tryandroidui";

	public ListActivityEx2Adapter(Context context) {
		super(context, 0);
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.widget.ArrayAdapter#getView(int, android.view.View,
	 * android.view.ViewGroup)
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		Log.d(TAG, "position=" + position + ",convertView=" + convertView
				+ ",parent=" + parent);

		// データ取得
		ListActivityExDto dto = getItem(position);

		// View取得
		View view;
		if (convertView == null) {
			// View生成
			view = createView(getContext(), parent);
		} else {
			// Viewを使い回す
			view = convertView;
		}

		// 値を設定

		ImageView imageView = (ImageView) view
				.findViewById(R.id.ListRowImageView01);
		imageView.setImageResource(dto.imageId);

		TextView textView1 = (TextView) view
				.findViewById(R.id.ListRowTextView01);
		textView1.setTypeface(Typeface.DEFAULT_BOLD);
		textView1.setTextColor(dto.textColor);
		textView1.setText(dto.text1);

		TextView textView2 = (TextView) view
				.findViewById(R.id.ListRowTextView02);
		textView2.setTextColor(dto.textColor);
		textView2.setText(dto.text2);

		return view;
	}

	private View createView(Context context, ViewGroup parent) {
		LinearLayout view = new LinearLayout(context);
		view.setOrientation(LinearLayout.HORIZONTAL);

		ImageView imageView = new ImageView(context);
		imageView.setId(R.id.ListRowImageView01);
		view.addView(imageView);

		LinearLayout linearLayout = new LinearLayout(context);
		linearLayout.setOrientation(LinearLayout.VERTICAL);
		view.addView(linearLayout);

		TextView textView = new TextView(context);
		textView.setId(R.id.ListRowTextView01);
		linearLayout.addView(textView);

		TextView textView2 = new TextView(context);
		textView2.setId(R.id.ListRowTextView02);
		linearLayout.addView(textView2);

		return view;
	}

}
