//
//  ICSTodo.m
//  iCal to KS2
//
//  Created by FUJIDANA on 05/05/20.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "ICSTodo.h"
#import "NSCalendarDate+ICalendarSupport.h"

@implementation ICSTodo

#pragma mark initialization and deallocation
- (id)initWithICalendarRepresentation:(NSString *)string
{
	self = [super init];
	
	if (self != nil) {
		NSDictionary	*rootDict	= [ICSCalendarItem dictionaryWithRFC2425Representation:string];
		NSDictionary	*subDict;
		NSString		*valueTypeString, *tzidString, *valueString;
		
		// -- set unique identifier (UID). value: text --
		if ((subDict		= [rootDict objectForKey:@"UID"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			identifier = [valueString copy];
		}
		
		// -- set summary (SUMMARY). value: text. param: altrepparam, languageparam (optional). --
		if ((subDict		= [rootDict objectForKey:@"SUMMARY"]) && 
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setSummary:[ICSCalendarItem stringWithEscapedString:valueString]];
		}
		
		// -- set description (DESCRIPTION). value: text. param: altrepparam, languageparam (optional). --
		if ((subDict		= [rootDict objectForKey:@"DESCRIPTION"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setNotes:[ICSCalendarItem stringWithEscapedString:valueString]];
		}
		
		// -- set sequence (SEQUENCE). value: integer. --
		if ((subDict		= [rootDict objectForKey:@"SEQUENCE"]) && 
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setSequence:[valueString intValue]];
		}
		
		// -- set date-time stamp (DTSTAMP). value: date-time. param: time zone is not allowed. --
		if ((subDict		= [rootDict objectForKey:@"DTSTAMP"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setStampDate:[NSCalendarDate dateWithICalendarDateTimeString:valueString
																	  timeZone:nil]];
		}
		// -- set URL (URL). value: uri. --
		if ((subDict		= [rootDict objectForKey:@"URL"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setUrl:valueString];
		}
		
		// -- set start date (DTSTART). value: dtstval (date-time/date). param: VALUE=(DATE-TIME | DATE), tzidparam --
		if ((subDict		= [rootDict objectForKey:@"DTSTART"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			valueTypeString	= [subDict objectForKey:@"VALUE"];
			tzidString		= [subDict objectForKey:@"TZID"];
			if (valueTypeString && [valueTypeString isEqualToString:@"DATE"]) {
				[self setStartDate:[NSCalendarDate dateWithICalendarDateString:valueString]];
			} else {
				[self setStartDate:[NSCalendarDate dateWithICalendarDateTimeString:valueString
																	timeZoneString:tzidString]];
			}
		}
		
		// -- set completion date (COMPLETED) --
		if ((subDict		= [rootDict objectForKey:@"COMPLETED"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setCompletionDate:[NSCalendarDate dateWithICalendarDateTimeString:valueString
																	 timeZoneString:nil]];
		}
				
		// -- set due date (DUE) --
		if ((subDict		= [rootDict objectForKey:@"DUE"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			valueTypeString	= [subDict objectForKey:@"VALUE"];
			tzidString		= [subDict objectForKey:@"TZID"];
			if (valueTypeString && [valueTypeString isEqualToString:@"DATE"]) {
				[self setDueDate:[NSCalendarDate dateWithICalendarDateString:valueString]];
			} else {
				[self setDueDate:[NSCalendarDate dateWithICalendarDateTimeString:valueString
																  timeZoneString:tzidString]];
			}
		}
		
		// -- set priority (PRIORITY) --
		if ((subDict		= [rootDict objectForKey:@"PRIORITY"]) &&
			(valueString	= [subDict objectForKey:@"_value"])) {
			
			[self setPriority:[valueString intValue]];
		}
		/*
		NSArray			*array		= [ICSCalendarItem arrayWithRFC2425Representation:string];
		NSEnumerator	*enumerator	= [array objectEnumerator];
		NSDictionary	*dictionary;
		NSString		*name, *value;
		NSDictionary	*param;
		while (dictionary = [enumerator nextObject]) {
			name	= [dictionary objectForKey:@"name"];
			param	= [dictionary objectForKey:@"param"];
			value	= [dictionary objectForKey:@"value"];
			
			NSCalendarDate	*tempDate;
			
			if (name == nil) {
				continue;
				
			// -- set unique identifier (UID). value: text --
			} else if ([name isEqualToString:@"UID"]) {
				identifier = [value copy];
			
			// -- set summary (SUMMARY). value: text --
			} else if ([name isEqualToString:@"SUMMARY"]) {
				[self setSummary:value];
			
			// -- set description (DESCRIPTION). value: text --
			} else if ([name isEqualToString:@"DESCRIPTION"]) {
				[self setNotes:value];
			
			// -- set sequence (SEQUENCE). value: integer --
			} else if ([name isEqualToString:@"SEQUENCE"]) {
				[self setSequence:[value intValue]];
			
			// -- set stamp date (DTSTAMP). value: date-time. param: not allowed timeZone. --
			} else if ([name isEqualToString:@"DTSTAMP"]) {
				[self setStampDate:[NSCalendarDate dateWithICalendarDateTimeString:value
																		  timeZone:nil]];
			
			// -- set URL (URL). value: uri --
			} else if ([name isEqualToString:@"URL"]) {
				[self setUrl:value];
				
			// -- set start date (DTSTART) --
			} else if ([name isEqualToString:@"DTSTART"]) {
				if (param && [[param objectForKey:@"VALUE"] isEqualToString:@"DATE"]) {
					if (tempDate = [NSCalendarDate dateWithICalendarDateString:value]) {
						[self setStartDate:tempDate];
					}
				} else {
					if (tempDate = [NSCalendarDate dateWithICalendarDateTimeString:value 
																	timeZoneString:[param objectForKey:@"TZID"]]) {
						[self setStartDate:tempDate];
					}
				}
				
			// -- set completion date (COMPLETED) --
			} else if ([name isEqualToString:@"COMPLETED"]) {
				if (tempDate = [NSCalendarDate dateWithICalendarDateTimeString:value
																timeZoneString:nil]) {
					[self setCompletionDate:tempDate];
				}
				
			// -- set due date (DUE) --
			} else if ([name isEqualToString:@"DUE"]) {
				if (param && [[param objectForKey:@"VALUE"] isEqualToString:@"DATE"]) {
					if (tempDate = [NSCalendarDate dateWithICalendarDateString:value]) {
						[self setDueDate:tempDate];
					}
				} else {
					if (tempDate = [NSCalendarDate dateWithICalendarDateTimeString:value 
																	timeZoneString:[param objectForKey:@"TZID"]]) {
						[self setDueDate:tempDate];
					}
				}
			
			// -- set priority (PRIORITY) --
			} else if ([name isEqualToString:@"PRIORITY"]) {
				[self setPriority:[value intValue]];
			}
		}
		*/
	}
	return self;
}

- (void) dealloc {
	[self setCompletionDate:nil];
	[self setDueDate:nil];
	
	[self setStartDate:nil];
	
	[super dealloc];
}

#pragma mark implementation method for NSCopying
- (id)copyWithZone:(NSZone *)zone
{
    id newObject = [super copyWithZone:zone];
	[newObject setCompletionDate:[self completionDate]];
	[newObject setDueDate:[self dueDate]];
	[newObject setPriority:[self priority]];
	[newObject setStartDate:[self startDate]];
	
	return newObject;
}

#pragma mark accessor methods
- (NSCalendarDate *)completionDate
{
	return completionDate;
}
- (void)setCompletionDate:(NSCalendarDate *)value
{
	if (completionDate != value) {
		[completionDate release];
		completionDate = [value copy];
	}
}

- (NSCalendarDate *)dueDate
{
	return dueDate;
}
- (void)setDueDate:(NSCalendarDate *)value
{
	if (dueDate != value) {
		[dueDate release];
		dueDate = [value copy];
	}
}

- (int)priority
{
	return priority;
}
- (void)setPriority:(int)value
{
	priority = value;
}

- (NSCalendarDate *)startDate
{
	return startDate;
}
- (void)setStartDate:(NSCalendarDate *)value
{
	if (startDate != value) {
		[startDate release];
		startDate = [value copy];
	}
}

@end
