//
//  GetMetadataForFile.m
//  AnotherKyoponUtilities_MDImporter
//
//  Created by FUJIDANA on 06/09/11.
//  Copyright (c) 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#include <CoreFoundation/CoreFoundation.h>
#include <CoreServices/CoreServices.h> 
#import <Foundation/Foundation.h>


#define kMDItemWXKURL @"jp_sourceforge_kyoponutilities_AnotherKyoponBookmarkUtility_URL"


Boolean GetMetadataForFile(void* thisInterface, 
			   CFMutableDictionaryRef attributes, 
			   CFStringRef contentTypeUTI,
			   CFStringRef pathToFile)
{
    /* Pull any available metadata from the file at the specified path */
    /* Return the attribute keys and attribute values in the dict */
    /* Return TRUE if successful, FALSE if there was no data provided */
    
	BOOL result = NO;
	
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	if ([(NSString *)contentTypeUTI isEqualToString:@"jp.sourceforge.kyoponutilities.bookmark"]) {
		NSDictionary *dictionary = [NSDictionary dictionaryWithContentsOfFile:(NSString *)pathToFile];
		if (dictionary != nil) {
			NSString *title       = [dictionary objectForKey:@"title"];
			NSString *URLString   = [dictionary objectForKey:@"url"];
			if (title) {
				[(NSMutableDictionary *)attributes setObject:title forKey:(NSString *)kMDItemDisplayName];
				result = YES;
			}
			if (URLString) {
				[(NSMutableDictionary *)attributes setObject:URLString forKey:kMDItemWXKURL];
				result = YES;
			}
		}
	}
	
	[pool release];
	
	return (Boolean)result;
}
