//
//  ICSTodo.h
//  iCal to KS2
//
//  Created by FUJIDANA on 05/05/20.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import <Foundation/Foundation.h>
#import "ICSCalendarItem.h"

typedef enum {
	AHKNoPriority = 0, 
	AHKLowPriority = 9, 
	AHKMediumPriority = 5, 
	AHKHighPriority = 1
} ICSTodoPriority;

@interface ICSTodo : ICSCalendarItem <NSCopying> {
	NSCalendarDate	*completionDate;
	NSCalendarDate	*dueDate;
	int				priority;
	
	NSCalendarDate	*startDate;
}

- (id)initWithICalendarRepresentation:(NSString *)string;

- (NSCalendarDate *)completionDate;
- (void)setCompletionDate:(NSCalendarDate *)value;
- (NSCalendarDate *)dueDate;
- (void)setDueDate:(NSCalendarDate *)value;
- (int)priority;
- (void)setPriority:(int)value;

- (NSCalendarDate *)startDate;
- (void)setStartDate:(NSCalendarDate *)value;
@end
