//
//  NSCalendarDate+ICSSupport.m
//  iCal to KS2
//
//  Created by FUJIDANA on 05/05/23.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "NSCalendarDate+ICalendarSupport.h"


@implementation NSCalendarDate (ICalendarSupport)

+ (id)dateWithICalendarDateString:(NSString *)string
{
	return [NSCalendarDate dateWithString:string calendarFormat:@"%Y%m%d"];
}

// 20050101T120000Z
+ (id)dateWithICalendarDateTimeString:(NSString *)string timeZone:(NSTimeZone *)timeZone
{
	if (string == nil || [string length] < 15 || [string length] > 16 || [string characterAtIndex:8] != 0x0054) { // 0x0054 == 'T'
		return nil;
	}
	
	// --  set timeZone --
	if (timeZone == nil) {
		if ([string length] == 16 && [string characterAtIndex:15] == 0x005a) { // 0x005a == 'Z'
			timeZone = [NSTimeZone timeZoneWithName:@"UTC"];
		} else {
			timeZone = [NSTimeZone localTimeZone];
		}
	}
	
	int year, month, day, hour, minute, second;
	year	= [[string substringWithRange:NSMakeRange(0, 4)] intValue];
	month	= [[string substringWithRange:NSMakeRange(4, 2)] intValue];
	day		= [[string substringWithRange:NSMakeRange(6, 2)] intValue];
	hour	= [[string substringWithRange:NSMakeRange(9, 2)] intValue];
	minute	= [[string substringWithRange:NSMakeRange(11, 2)] intValue];
	second	= [[string substringWithRange:NSMakeRange(13, 2)] intValue];

	NSCalendarDate *date = [NSCalendarDate dateWithYear:year
								  month:month
									day:day
								   hour:hour
								 minute:minute
								 second:second
							   timeZone:timeZone];
							   return date;
}

/*
+ (id)dateWithYear:(int)year month:(unsigned)month weekOfMonth:(int)nth dayOfWeek:(unsigned)dayOfWeek hour:(unsigned)hour minute:(unsigned)minute second:(unsigned)second timeZone:(NSTimeZone *)timeZone
{
	NSCalendarDate	*dateAtBeginningOfMonth	= [NSCalendarDate dateWithYear:year
																	 month:month
																	   day:1
																	  hour:hour
																	minute:minute
																	second:second
																  timeZone:timeZone];
	NSCalendarDate	*returnedDate;
	
	if (nth > 0) {
		int intervalDaysOfWeek = (dayOfWeek - [dateAtBeginningOfMonth dayOfWeek] + 7) % 7;
		
		returnedDate = [dateAtBeginningOfMonth dateByAddingDays:((nth - 1) * 7 + intervalDaysOfWeek)];
		if ([returnedDate monthOfYear] == month && [returnedDate yearOfCommonEra] == year) {
			return returnedDate;
		} else {
			return nil;
		}
	} else if (nth < 0) {
		NSCalendarDate *dateAtEndOfMonth = [[dateAtBeginningOfMonth dateByAddingMonths:1] dateByAddingDays:-1];
		int intervalDaysOfWeek = ([dateAtEndOfMonth dayOfWeek] - dayOfWeek + 7) % 7;
		returnedDate = [dateAtEndOfMonth dateByAddingDays:((1 - nth) * 7 - intervalDaysOfWeek)];
		if ([returnedDate monthOfYear] == month && [returnedDate yearOfCommonEra] == year) {
			return returnedDate;
		} else {
			return nil;
		}
	}
	return nil;
}
*/

+ (id)dateWithICalendarDateTimeString:(NSString *)string timeZoneString:(NSString *)timeZoneString
{
	NSTimeZone *timeZone = nil;
	
	if (timeZoneString) {
		timeZone = [NSTimeZone timeZoneWithName:timeZoneString];
	}
	
	return [self dateWithICalendarDateTimeString:string timeZone:timeZone];
}

- (NSCalendarDate *)dateByAddingDays:(int)day
{
	return [self dateByAddingYears:0
							months:0
							  days:day
							 hours:0
						   minutes:0
						   seconds:0];
}

- (NSCalendarDate *)dateByAddingMonths:(int)months
{
	NSCalendarDate *date = [self dateByAddingYears:0
											months:months
											  days:0
											 hours:0
										   minutes:0
										   seconds:0];
	if ([date dayOfMonth] == [self dayOfMonth]) {
		return date;
	} else {
		return nil;
	}
}

/*
- (NSCalendarDate *)dateByAddingYears:(int)years
{
	NSCalendarDate *date = [self dateByAddingYears:years
											months:0
											  days:0
											 hours:0
										   minutes:0
										   seconds:0];
	if ([date dayOfMonth] == [self dayOfMonth] &&
		[date monthOfYear] == [self monthOfYear]) {
		return date;
	} else {
		return nil;
	}
}
*/

- (NSCalendarDate *)dateAtBeginningOfDay
{
	return [self dateByAddingYears:0
							months:0
							  days:0
							 hours:(- [self hourOfDay])
						   minutes:(- [self minuteOfHour])
						   seconds:(- [self secondOfMinute])];
}

- (NSCalendarDate *)dateAtEndOfDay
{
	return [self dateByAddingYears:0
							months:0
							  days:0
							 hours:(23 - [self hourOfDay])
						   minutes:(59 - [self minuteOfHour])
						   seconds:(59 - [self secondOfMinute])];
}

- (NSCalendarDate *)dateAtBeginningOfMonth
{
	return [self dateByAddingYears:0
							months:0
							  days:(1 - [self dayOfMonth])
							 hours:0
						   minutes:0
						   seconds:0];
}

- (NSCalendarDate *)dateAtEndOfMonth
{
	NSCalendarDate *tempDate =  [self dateByAddingYears:0
												 months:0
												   days:(1 - [self dayOfMonth])
												  hours:0
												minutes:0
												seconds:0];
	tempDate = [tempDate dateByAddingMonths:1];
	tempDate = [tempDate dateByAddingDays:-1];
	return tempDate;
}

- (int)weekOfMonth
{
	return ([self dayOfMonth] - 1) / 7 + 1;
}

- (int)reverseWeekOfMonth
{
	NSCalendarDate *tempDate = [self dateAtEndOfMonth];
	int dayOfMonth = [tempDate dayOfMonth];
	
	return ([self dayOfMonth] - dayOfMonth) / 7 - 1;
}

@end
