/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.util.Rnd;

public class L2PenaltyMonsterInstance extends L2MonsterInstance
{
	private L2PcInstance _ptk;
	
	//[JOJO]-------------------------------------------------
	final int[] _randomNpcStrings;
	/*
	 * [0-2] onSpawn
	 * [3-5] random timer
	 * [6-8] onKill
	 */
	private static final int[] S18319 =	//ނꂽJG
	{
		1010400, //PPbIȂƂ$s1ȂāIH
		1010401, //$s1AˁI
		1010402, //ނԈႦČA$s1I
		
		1010403, //JGÂႢB
		1010404, //JG̗͂Ă낤I
		1010405, //ňݍłI
		
		1010406, //StbDDD̃IlʂȂāI
		1010407, //QRQRIJGEI
		1010408, //JG͔ȂłIB
	};
	private static final int[] S18320 =	//ނꂽEfB[l
	{
		1010409, //ႠI$s1ÂH
		1010410, //ӂӂA$s1̑̂ɏȂāBo͂łĂł傤ˁH
		1010411, //A$s1 Ȃ̂ˁBłˁAȍrۂ҂ɊԏȂĂȂH
		
		1010412, //{点ˁI
		1010413, //̏AǂĂ̂IH
		1010414, //񂽂ڂɂ킹ĂII
		
		1010415, //ႠIˁAoĂႢI
		1010416, //Ȃ̃GT͐HׂȂāA̋Ɍӂ炵ĂI
		1010417, //݂Ȃア߂ȂāDDDB
	};
	private static final int[] S18321 =	//ނꂽN
	{
		1010418, //PPPDDD$s1DDDHׂ邼DDDPPbDDD
		1010419, //ODDDDDD$s1DDD߂DDDǂDDD
		1010420, //$s1HPzbDDDODDDObDDD
		
		1010421, //NPPPPINIXsIA^AAAAAbNI
		1010422, //IpvIIII
		1010423, //NINI@@NDDDDI
		
		1010424, //NGFDDD݁DDDDDD
		1010425, //HꂽȂDDDOA@
		1010426, //OnbINIPzbPzbIOGFDDD
	};
	private static final int[] S18322 =	//ނꂽV[WCAg
	{
		1010427, //pvIɉhI$s1ɂ͎I
		1010428, //$s1AOỈ߂Ă̂́I
		1010429, //lI$s1Ɏ􂢂I
		
		1010430, //WCAg XyV A^bNI
		1010431, //݂̍vmI
		1010432, //̑HĂ݂I
		
		1010433, //pvIlɉhI
		1010434, //͂I
		1010435, //V͎ȂDDD̂݁DDD
	};
	private static final int[] S18323 =	//ނꂽV[z[X \W[
	{
		1010436, //$s1A̐̋Rm̒󂯂I
		1010437, //̕񍐂ɂ$s1I
		1010438, //$s1A킦̂͂񂽂̃GT̂I
		
		1010439, //{d݂̑pI
		1010440, //񂽂ɑŊ̃v[gI
		1010441, //񂽂̃GT͎|IႠȁI
		
		1010442, //I䂪E݂̍I
		1010443, //oĂI̋w͂ƒNDDD
		1010444, //OtbDDDOɂ͕߂܂ȂI
	};
	private static final int[] S18324 =	//ނꂽzNX
	{
		1010445, //$s1ADDD
		1010446, //$s1A[Cɂ鉴ނグȂāDDD
		1010447, //$s1AɌ邩B
		
		1010448, //͂قЂ`
		1010449, //NNNbAǂA񂪂ĂĂ낤B
		1010450, //oĖfĂ񂾂H
		
		1010451, //ЂDDDɂDDDĂĂĂĂI
		1010452, //`FbAsDDD̂ɁB
		1010453, //DDD~DDDWWbDDD
	};
	private static final int[] S18325 =	//ނꂽt@
	{
		1010454, //NbI$s1`Nb|[B
		1010455, //$s1̓邼I
		1010456, //ȁA$s1I
		
		1010457, //HĂ邼I
		1010458, //ււցAvԂɂGTȁI
		1010459, //OȂ񂩈I
		
		1010460, //DDDGTɂȂāI
		1010461, //Õ͉GTȂ񂾂I߂ĐHĂI
		1010462, //GTɐHȂāDDDNbDDD
	};
	private static final int[] S18326 =	//ނꂽ
	{
		1010463, //ނ̂$s1H
		1010464, //ɉƂhɎvA$s1B
		1010465, //$s1AċAȂĂۂvȂقB
		
		1010466, //[̗͂ƂƌDDD
		1010467, //̒ނƂւ܂ĂDDD
		1010468, //Ml̎ŕẢDDD
		
		1010469, //̒ނtȂ̂DDD
		1010470, //pvI|Ȃ̂DDD
		1010471, //f炵AJ߂Ă邼DDD
	};
	//-------------------------------------------------------
	
	public L2PenaltyMonsterInstance(int objectId, L2NpcTemplate template)
	{
		super(objectId, template);
		setInstanceType(InstanceType.L2PenaltyMonsterInstance);
		//[JOJO]-------------------------------------------------
		switch (getNpcId())
		{
			case 18319: _randomNpcStrings = S18319; break;	//ނꂽJG
			case 18320: _randomNpcStrings = S18320; break;	//ނꂽEfB[l
			case 18321: _randomNpcStrings = S18321; break;	//ނꂽN
			case 18322: _randomNpcStrings = S18322; break;	//ނꂽV[WCAg
			case 18323: _randomNpcStrings = S18323; break;	//ނꂽV[z[X \W[
			case 18324: _randomNpcStrings = S18324; break;	//ނꂽzNX
			case 18325: _randomNpcStrings = S18325; break;	//ނꂽt@
			default:
			case 18326: _randomNpcStrings = S18326; break;	//ނꂽ
		}
		ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){
			@Override
			public void run()
			{
				if (isVisible() && !isDead())
				{
					broadcastPacket(new NpcSay(getObjectId(), Say2.ALL, getNpcId(), _randomNpcStrings[Rnd.get(3, 5)]));
					ThreadPoolManager.getInstance().scheduleGeneral(this, Rnd.get(5555, 9999));
				}
			}
		}, Rnd.get(5555, 9999));
		//-------------------------------------------------------
	}
	
	@Override
	public L2Character getMostHated()
	{
		if (_ptk != null)
			return _ptk; //always attack only one person
		return super.getMostHated();
	}
	
	public void setPlayerToKill(L2PcInstance ptk)
	{
		//[JOJO]-------------------------------------------------
		broadcastPacket(new NpcSay(getObjectId(), Say2.ALL, getNpcId(), _randomNpcStrings[Rnd.get(0, 2)]).addPcName(ptk));
		//-------------------------------------------------------
		_ptk = ptk;
		addDamageHate(ptk, 0, 10);
		getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, ptk);
		addAttackerToAttackByList(ptk);
	}
	
	@Override
	public boolean doDie(L2Character killer)
	{
		if (!super.doDie(killer))
			return false;
		
		//[JOJO]-------------------------------------------------
		broadcastPacket(new NpcSay(getObjectId(), Say2.ALL, getNpcId(), _randomNpcStrings[Rnd.get(6, 8)]));
		//-------------------------------------------------------
		return true;
	}
}
