package jp.sourceforge.lepidolite.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.beanutils.DynaBean;

public class GroupDao extends BaseDao {
	
	/**
	 * RXgN^B
	 * @param trans gUNVIuWFNgB
	 */
	public GroupDao(DaoTransaction trans) {
		super(trans);
	}
	
	
	/**
	 * O[v̈ꗗ擾B
	 * 
	 * @return O[ṽXgB
	 */
	public List<DynaBean> findGroups() {
		return findByCriteria("select" +
				" group_id, party_id, party_name" +
				", apply_from, apply_to" +
				" from groups" +
				" where party_type=1" +
				" and current_timestamp between apply_from and apply_to", null);
	}
	
	
	/**
	 * p[eBIDɏO[v擾B
	 * 
	 * @param partyId
	 * @return O[vB
	 */
	public DynaBean getGroupByPartyId(String partyId) {
		return getById("select" +
				" group_id, party_id, party_name" +
				", apply_from, apply_to" +
				" from groups" +
				" where party_id=?", new Object[]{partyId});
	}
	
	
	/**
	 * <var>partyId</var>Ŏw肵p[eB̒̐ȅ擾B 
	 * @param partyId ƂȂp[eBIDB
	 * @return O[vB
	 */
	public DynaBean getParentByPartyId(String partyId) {
		return getById("select" +
				" p.group_id, p.party_id, p.party_name" +
				", p.apply_from, p.apply_to" +
				" from groups c" +
				" left join groups p on p.lft<c.lft and p.lft=(select max(lft) from groups where c.lft>lft and c.lft<rgt)" +
				" where c.party_id=?", new Object[]{partyId});
	}
	
	
	/**
	 * O[vɃ[UǉB
	 * @param bean
	 * <dl>
	 * <dt>user_id</dt><dd>ǉ郆[Ũ[UID</dd>
	 * <dt>group_id</dt><dd>ǉ̃O[ṽO[vID</dd>
	 * </dl>
	 */
	public void addUser(DynaBean bean) {
		try {
			String userId = (String) bean.get("user_id");
			Integer groupId = (Integer) bean.get("group_id");
			
			Connection conn = trans.getConnection();
			
			// evfrgt擾
			DynaBean parent = getById("select rgt from groups where group_id=?", new Object[]{groupId});
			Integer parentRgt = (Integer) parent.get("rgt");
			
			// ǉm[h̐Ȃ󂯂
			PreparedStatement stmt1 = conn.prepareStatement("update groups set" +
					" lft=case when lft>? then lft+2 else lft end" +
					", rgt=case when rgt>=? then rgt+2 else rgt end" +
					", updated_by=?, updated_at=current_timestamp" +
					" where rgt>=?");
			stmt1.setObject(1, parentRgt);
			stmt1.setObject(2, parentRgt);
			stmt1.setObject(3, trans.getOwner());
			stmt1.setObject(4, parentRgt);
			stmt1.executeUpdate();
			
			// m[hǉ
			PreparedStatement stmt2 = conn.prepareStatement("insert into groups (" +
					"group_id, party_id, party_name, party_type, lft, rgt, apply_from, apply_to" +
					", created_by, created_at, updated_by, updated_at" +
					") values (" +
					"nextval('groups_id_seq'), ?, ?, 0, ?, ?, current_timestamp, '9999-12-31 23:59:59'" +
					", ?, current_timestamp, ?, current_timestamp" +
					")");
			stmt2.setObject(1, userId);
			stmt2.setObject(2, bean.get("user_name"));
			stmt2.setObject(3, parentRgt);
			stmt2.setObject(4, parentRgt+1);
			stmt2.setObject(5, trans.getOwner());
			stmt2.setObject(6, trans.getOwner());
			stmt2.executeUpdate();
		} catch (SQLException sqle) {
			throw new DaoException("[U̒ǉɎs܂B", sqle);
		}
	}
	
	
	/**
	 * O[v烆[U̍폜sB
	 * [U񎩑͍̂폜ȂB
	 * @param bean
	 * <dl>
	 * <dt>user_id</dt><dd>폜郆[Ũ[UIDB</dd>
	 * </dl>
	 */
	public void deleteUser(DynaBean bean) {
		try {
			Connection conn = trans.getConnection();
			// [U폜
			PreparedStatement stmt1 = conn.prepareStatement("delete from groups" +
					" where party_id=?" +
					" and party_type=0");
			stmt1.setObject(1, bean.get("user_id"));
			stmt1.executeUpdate();
		} catch (SQLException sqle) {
			throw new DaoException("[U̍폜Ɏs܂B", sqle);
		}
	}
	
	/**
	 * <var>lft</var>, <var>rgt</var>̌Ԃ𖄂߂B
	 * 
	 */
	public void shrink() {
		try {
			// Ԃ𖄂߂
			Connection conn = trans.getConnection();
			PreparedStatement stmt = conn.prepareStatement("update groups set" +
					" lft=(select count(*)" +
					" from (select lft as seq from groups union all select rgt from groups) s" +
					" where s.seq<=lft)" +
					", rgt=(select count(*)" +
					" from (select lft as seq from groups union all select rgt from groups) s" +
					" where s.seq<=rgt)");
			stmt.executeUpdate();
		} catch (SQLException sqle) {
			throw new DaoException("Ԃ𖄂߂鏈Ɏs܂B", sqle);
		}
	}
}
