#include <dirent.h>
#include <string.h>
#include <sys/stat.h>
#include "ar.h"

static unsigned long
store(FILE *rfp, FILE *wfp, unsigned int *crc)
{
    uint n;
    char buf[MAXDICSIZ];
    unsigned long sz = 0;

    *crc = INIT_CRC;
    while ((n = fread(buf, 1, sizeof(buf), rfp)) != 0) {
        fwrite_crc(buf, n, wfp, crc);
        sz += n;
    }
    return sz;
}

int
add_dir(struct lzh_ostream *wp, int replace_flag, struct lzh_header *h)
{
    long headerpos, arcpos;
    uint r;

    h->origsize = h->compsize = 0;
    h->file_crc = INIT_CRC;

    headerpos = ftell(wp->fp);
    write_header(wp->fp, h);
    arcpos = ftell(wp->fp);

    if (opts.quiet < 2)
        printf(" %d.%d%%\n", r / 10, r % 10);
    return 1;                   /* success */
}

static int
add_1(struct lzh_ostream *wp, int replace_flag, struct lzh_header *h)
{
    long headerpos, arcpos;
    uint r;
    FILE *rfp;

    if ((rfp = fopen(h->filename, "rb")) == NULL) {
        fprintf(stderr, "Can't open %s\n", h->filename);
        return 0;               /* failure */
    }
    if (replace_flag) {
        if (opts.quiet < 2)
            printf("Replacing %s ", h->filename);
    }
    else {
        if (opts.quiet < 2)
            printf("Adding %s ", h->filename);
    }

    headerpos = ftell(wp->fp);
    write_header(wp->fp, h);
    arcpos = ftell(wp->fp);

    wp->origsize = wp->compsize = 0;
    wp->crc = INIT_CRC;
    if (opts.nocompress) {
        wp->unpackable = 1;
    }
    else {
        wp->unpackable = 0;
        encode(wp, rfp);
    }

    if (wp->unpackable) {
        memcpy(h->method, "-lh0-", sizeof(h->method));  /* store */
        rewind(rfp);
        fseek(wp->fp, arcpos, SEEK_SET);
        h->compsize = h->origsize = store(rfp, wp->fp, &wp->crc);
    }
    else {
        h->compsize = wp->compsize;
        h->origsize = wp->origsize;
    }
    h->file_crc = wp->crc ^ INIT_CRC;
    fclose(rfp);

    fseek(wp->fp, headerpos, SEEK_SET);
    write_header(wp->fp, h);
    fseek(wp->fp, 0L, SEEK_END);
    r = ratio(wp->compsize, wp->origsize);
    if (opts.quiet < 2)
        printf(" %d.%d%%\n", r / 10, r % 10);
    return 1;                   /* success */
}

int
add(struct lzh_ostream *wp, int replace_flag, char *filename, int namelen)
{
    struct lzh_header h;
    struct stat st;

    memset(&h, 0, sizeof(h));

    h.level = opts.header_level;

    strcpy(h.filename, filename);
    h.namelen = namelen;

    stat(h.filename, &st);

    h.mtime = st.st_mtime;
    if (S_ISDIR(st.st_mode)) {
        DIR *dir;
        struct dirent *ent;

        memcpy(h.method, "-lhd-", sizeof(h.method));  /* directory */
        add_dir(wp, replace_flag, &h);

        dir = opendir(h.filename);
        if (dir == NULL)
            error("cannot open directory: \"%s\"", h.filename);

        while ((ent = readdir(dir)) != 0) {
            char filename[1024];

            if (string_equal(ent->d_name, ".") ||
                string_equal(ent->d_name, ".."))
                continue;

            h.namelen = path_addsep(h.filename, sizeof(h.filename));

            string_cat(filename, sizeof(filename),
                       h.filename, ent->d_name, NULL);

            add(wp, replace_flag, filename, strlen(filename));
        }
        closedir(dir);
    }
    else {
        memcpy(h.method, opts.method->id, sizeof(h.method));  /* compress */
        add_1(wp, replace_flag, &h);
    }
}
