/***********************************************************
	io.c -- input/output
***********************************************************/
#include "ar.h"

#define CRCPOLY  0xA001         /* ANSI CRC-16 */
                         /* CCITT: 0x8408 */

ushort crctable[UCHAR_MAX + 1];

void
make_crctable(void)
{
    uint i, j, r;

    for (i = 0; i <= UCHAR_MAX; i++) {
        r = i;
        for (j = 0; j < CHAR_BIT; j++)
            if (r & 1)
                r = (r >> 1) ^ CRCPOLY;
            else
                r >>= 1;
        crctable[i] = r;
    }
}

void
fillbuf(struct lzh_istream *rp, int n)
{                               /* Shift bitbuf n bits left, read n bits */
    rp->bitbuf <<= n;
    while (n > rp->bitcount) {
        rp->bitbuf |= rp->subbitbuf << (n -= rp->bitcount);
        if (rp->compsize != 0) {
            rp->compsize--;
            rp->subbitbuf = (uchar) getc(rp->fp);
        }
        else
            rp->subbitbuf = 0;
        rp->bitcount = CHAR_BIT;
    }
    rp->bitbuf |= rp->subbitbuf >> (rp->bitcount -= n);
}

uint
getbits(struct lzh_istream *rp, int n)
{
    uint x;

    x = rp->bitbuf >> (BITBUFSIZ - n);
    fillbuf(rp, n);
    return x;
}

void
putbits(struct lzh_ostream *wp, int n, uint x)
{                               /* Write rightmost n bits of x */
    if (n < wp->bitcount) {
        wp->subbitbuf |= x << (wp->bitcount -= n);
    }
    else {
        if (wp->compsize < wp->origsize) {
            putc(wp->subbitbuf | (x >> (n -= wp->bitcount)), wp->fp);
            wp->compsize++;
        }
        else
            wp->unpackable = 1;
        if (n < CHAR_BIT) {
            wp->subbitbuf = x << (wp->bitcount = CHAR_BIT - n);
        }
        else {
            if (wp->compsize < wp->origsize) {
                putc(x >> (n - CHAR_BIT), wp->fp);
                wp->compsize++;
            }
            else
                wp->unpackable = 1;
            wp->subbitbuf = x << (wp->bitcount = 2 * CHAR_BIT - n);
        }
    }
}

int
fread_crc(void *p, int n, FILE * f, unsigned int *crc)
{
    int i;

    i = n = fread(p, 1, n, f);
    if (crc) {
        while (--i >= 0)
            UPDATE_CRC(*crc, *(unsigned char*)p++);
    }
    return n;
}

void
fwrite_crc(void *p, int n, FILE * f, unsigned int *crc)
{
    if (fwrite(p, 1, n, f) < n)
        error("Unable to write");
    if (crc) {
        while (--n >= 0)
            UPDATE_CRC(*crc, *(unsigned char*)p++);
    }
}

void
init_getbits(struct lzh_istream *rp)
{
    rp->bitbuf = 0;
    rp->subbitbuf = 0;
    rp->bitcount = 0;
    fillbuf(rp, BITBUFSIZ);
}

void
init_putbits(struct lzh_ostream *wp)
{
    wp->bitcount = CHAR_BIT;
    wp->subbitbuf = 0;
}
