#! python

import sys
import os
import string
import re
import commands
import filecmp
import glob
import shutil
import traceback

import lha-test001.py

top_dir = os.getcwd()
lha_cmd = os.path.join(top_dir, '../olha')

def lha_exec(args):
    cmd = lha_cmd + ' ' + re.sub(r'\n', '', args)
    # cmd = commands.mkarg(cmd)
    print '>>>', cmd,
    status, output = commands.getstatusoutput(cmd)
    print ' --> ', status >> 8
    print output
    if status != 0:
        raise RuntimeError, 'test failed (%d)' % (status >> 8,)
    return output

def message(*args):
    if len(args) == 0:
        sys.__stdout__.write('\n')
        return

    if args[-1] is True:
        nonewline = True
        args = args[0:-1]
    else:
        nonewline = False

    for s in args:
        sys.__stdout__.write(s)
        if not nonewline:
            sys.__stdout__.write('\n')

def setup():
    f = open('test-a', 'w')
    for i in xrange(100):
        f.write('foo')
    f.close

    f = open('test-a')
    buf = f.read()
    f.close

    f = open('test-b', 'w')
    f.write(re.sub('foo', 'bar', buf))
    f.close

    f = open('test-c', 'w')
    f.write(re.sub('foo', 'baz', buf))
    f.close

def teardown():
    for f in glob.iglob('test-*'):
        if os.path.isdir(f):
            shutil.rmtree(f)
        else:
            os.remove(f)

def do_test(no, log, test):
    message('test #%d ... ' % no, True)
    try:
        dir = 'test-%d' % no
        test_dir = os.path.join(top_dir, dir)
        os.path.exists(dir) or os.mkdir(dir)
        os.chdir(dir)
        sys.stdout = log
        setup()
        test()
    except:
        print traceback.print_exception(*sys.exc_info())
        message('ng')
        raise sys.exc_info()
    else:
        message('ok')
    finally:
        os.chdir(top_dir)
        teardown()
        sys.stdout = sys.__stdout__

if __name__ == '__main__':
    log = open('test.log', 'w')
    do_test(1, log, lha_test1)
