/* ------------------------------------------------------------------------ */
/* LHa for UNIX                                                             */
/*              extract.c -- extrcat from archive                           */
/*                                                                          */
/*      Modified                Nobutaka Watazaki                           */
/*                                                                          */
/*  Ver. 1.14   Source All chagned              1995.01.14  N.Watazaki      */
/* ------------------------------------------------------------------------ */
#include "lha.h"

int
decode_lzhuf(infp, outfp, original_size, packed_size, name, method, read_sizep)
    FILE           *infp;
    FILE           *outfp;
    size_t          original_size;
    size_t          packed_size;
    char           *name;
    int             method;
    size_t         *read_sizep;
{
    unsigned int crc;

    interface.method = method;
    interface.dicbit = 13;  /* method + 8; -lh5- */
    interface.infile = infp;
    interface.outfile = outfp;
    interface.original = original_size;
    interface.packed = packed_size;
    interface.read_size = 0;

    *read_sizep = packed_size;

    switch (method) {
    case LZHUFF0_METHOD_NUM:
    case LARC4_METHOD_NUM:
        start_indicator(name, original_size
                  ,verify_mode ? "Testing " : "Melting ", 2048);
        *read_sizep = copyfile(infp, (verify_mode ? NULL : outfp),
                               original_size, 2, &crc);
        break;
    case LARC_METHOD_NUM:       /* -lzs- */
        interface.dicbit = 11;
        start_indicator(name, original_size
                ,verify_mode ? "Testing " : "Melting "
                ,1 << interface.dicbit);
        crc = decode(&interface);
        *read_sizep = interface.read_size;
        break;
    case LZHUFF1_METHOD_NUM:        /* -lh1- */
    case LZHUFF4_METHOD_NUM:        /* -lh4- */
    case LARC5_METHOD_NUM:          /* -lz5- */
        interface.dicbit = 12;
        start_indicator(name, original_size
                ,verify_mode ? "Testing " : "Melting "
                ,1 << interface.dicbit);
        crc = decode(&interface);
        *read_sizep = interface.read_size;
        break;
    case LZHUFF6_METHOD_NUM:        /* -lh6- */ /* Added N.Watazaki (^_^) */
#ifdef SUPPORT_LH7
    case LZHUFF7_METHOD_NUM:                /* -lh7- */
#endif
        interface.dicbit = (method - LZHUFF6_METHOD_NUM) + 15;
        /* fall through */
    default:
        start_indicator(name, original_size
                ,verify_mode ? "Testing " : "Melting "
                ,1 << interface.dicbit);
        crc = decode(&interface);
        *read_sizep = interface.read_size;
    }
    finish_indicator(name, verify_mode ? "Tested  " : "Melted  ");

    return crc;
}
