#!/usr/bin/perl
use strict;
use FileHandle;
my $release=0;
foreach my $ARGV (@ARGV){
  if($ARGV=~ m!^--release!){
    $release++;
  }
}

my $version='';
if(my $fh=new FileHandle("Changes")){
  while(<$fh>){
    my $line=$_;
    if($line=~ m!^([\d\.]+)!){
      $version=$1;
    }
    last;
  }
  $fh->close();
}
if($version){
  if($release){
    my $dir='lib1stclass-'.$version;
    my @cm=('mkdir '.$dir, 'cp *.c '.$dir, 'cp *.cpp '.$dir, 'cp *.h '.$dir, 'cp *.hpp '.$dir, 'cp *.pl '.$dir, 'cp Makefile '.$dir, 'cp Changes '.$dir, 'cp README '.$dir, 'mkdir -p '.$dir.'/t', 'cp t/*.cpp '.$dir.'/t', 'cp t/*.c '.$dir.'/t', 'tar cvf '.$dir.'.src.tar '.$dir, 'gzip '.$dir.'.src.tar', 'rm -rf '.$dir);
    foreach my $cm (@cm){
      print $cm."\n";
      system($cm);
    }
  }
  else{
    my @files=('/usr/local/include/lib1stclass.hpp', '/usr/local/include/lib1stclass.h');
    foreach my $file (@files){
      if(my $fh=new FileHandle($file)){
        local $/=undef;
        my $con=<$fh>;
        $fh->close();
        unless($con=~ m!// VERSION=[\d\.]+ //!){
          if(my $fh=new FileHandle('>> '.$file)){
            print $fh "\n// VERSION=".$version."//\n";
            $fh->close();
          }
        }
      }
    }
  }
}
