/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef __cplusplus
#include "1stclass.hpp"
#include<iostream>a
#include<string>
string firstclass::host2ip(const string server_str){
  char ip[32]="";
  char *server=NULL;
  try{
    server=new char[sizeof(char)*(server_str.length()+1)];
    server[0]='\0';
    safe_strcat(server, server_str.c_str(), sizeof(char)*(server_str.length()+1));
#else
#include "1stclass.h"
int host2ip(const char *server, char *ip){
#endif
  struct addrinfo hint, *res, *p;
  int error=0;
  char ipstr[INET6_ADDRSTRLEN];
  
  memset(&hint, 0, sizeof(hint));
  hint.ai_family = PF_INET;
  hint.ai_socktype = SOCK_STREAM;

  error = getaddrinfo(server, "http", &hint, &res);

  if(error){
    fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(error));

#ifdef __cplusplus
    delete[] server;
    return "";
#else
    return 1;
#endif
  }
  
  for(p = res;p != NULL; p = p->ai_next) {
    void *addr;
    char *ipver;
    
    if (p->ai_family == AF_INET) { // IPv4
      struct sockaddr_in *ipv4 = (struct sockaddr_in *)p->ai_addr;
      addr = &(ipv4->sin_addr);
      ipver = "IPv4";
    } else { // IPv6
      struct sockaddr_in6 *ipv6 = (struct sockaddr_in6 *)p->ai_addr;
      addr = &(ipv6->sin6_addr);
      ipver = "IPv6";
    }
    
    // convert the IP to a string and print it:
    inet_ntop(p->ai_family, addr, ipstr, sizeof ipstr);
  }
  freeaddrinfo(res); // free the linked list
  
#ifdef __cplusplus
    delete[] server;
    firstclass::safe_strcat(ip, ipstr, sizeof(ip));
    string last_ip(ip);
    return last_ip;
  }
  catch(...){
    if(server!=NULL)
      delete[] server;
    return "";
  }
#else
  safe_strcat(ip, ipstr, sizeof(ip));
  return 0;
#endif
}
