/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>

#ifdef __cplusplus
#include "1stclass.hpp"
int firstclass::rmkdir(const string in_dir){
  char abs_dir[2048]="";
  string abs_dir_str=rel2abs(in_dir);
  safe_strcat(abs_dir, abs_dir_str.c_str(), sizeof(abs_dir));
#else
#include "1stclass.h"
int rmkdir(const char *check_dir){
  char abs_dir[2048]="";
  rel2abs(check_dir, abs_dir);
#endif
  
  struct stat st;
  char *token_p=NULL;
  char dir_path[2048]="";
  char moto[2048]="";
  if(stat(abs_dir, &st)!=0){
    if(mkdir(abs_dir, 0755)==0){
    }
    else{
      safe_strcat(moto, abs_dir, sizeof(moto));
      token_p=strtok(moto, "/");
      safe_strcat(dir_path, "/", sizeof(dir_path));
      safe_strcat(dir_path, token_p, sizeof(dir_path));
      if(stat(dir_path, &st)!=0){
        if(mkdir(dir_path, 0755)==0){
        }
        else{
          return 1;
        }
      }
      while((token_p=strtok(NULL,"/"))!=NULL){
        safe_strcat(dir_path, "/", sizeof(dir_path));
        safe_strcat(dir_path, token_p, sizeof(dir_path));
        if(stat(dir_path, &st)!=0){
          if(mkdir(dir_path, 0755)==0){
          }
          else{
            return 1;
          }
        }
      }
    }
  }
  return 0;
}
